/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.color;

import de.sillysky.nyssr.util.swing.color.CNamedColor;
import java.util.HashMap;
import java.util.Map;

public final class CNamedColors {
    private static final Map<String, CNamedColor> NAME_TO_COLOR = new HashMap<String, CNamedColor>();
    private static final Map<Integer, CNamedColor> HASH_TO_COLOR = new HashMap<Integer, CNamedColor>();

    private CNamedColors() {
    }

    private static void add(String aName, String aColor) {
        String n = aName.trim();
        CNamedColor c = new CNamedColor(n, aColor);
        NAME_TO_COLOR.put(n.toLowerCase(), c);
        int hash = c.getHash();
        HASH_TO_COLOR.put(hash, c);
    }

    public static CNamedColor get(int aRed, int aGreen, int aBlue) {
        int hash = CNamedColor.getHash(aRed, aGreen, aBlue);
        return HASH_TO_COLOR.get(hash);
    }

    public static CNamedColor get(String aName) {
        if (aName == null) {
            return null;
        }
        String n = aName.trim().toLowerCase();
        return NAME_TO_COLOR.get(n);
    }

    static {
        CNamedColors.add("AliceBlue", "#F0F8FF");
        CNamedColors.add("AntiqueWhite", "#FAEBD7");
        CNamedColors.add("Aqua", "#00FFFF");
        CNamedColors.add("Aquamarine", "#7FFFD4");
        CNamedColors.add("Azure", "#F0FFFF");
        CNamedColors.add("Beige", "#F5F5DC");
        CNamedColors.add("Bisque", "#FFE4C4");
        CNamedColors.add("Black", "#000000");
        CNamedColors.add("BlanchedAlmond", "#FFEBCD");
        CNamedColors.add("Blue", "#0000FF");
        CNamedColors.add("BlueViolet", "#8A2BE2");
        CNamedColors.add("Brown", "#A52A2A");
        CNamedColors.add("BurlyWood", "#DEB887");
        CNamedColors.add("CadetBlue", "#5F9EA0");
        CNamedColors.add("Chartreuse", "#7FFF00");
        CNamedColors.add("Chocolate", "#D2691E");
        CNamedColors.add("Coral", "#FF7F50");
        CNamedColors.add("CornflowerBlue", "#6495ED");
        CNamedColors.add("Cornsilk", "#FFF8DC");
        CNamedColors.add("Crimson", "#DC143C");
        CNamedColors.add("Cyan", "#00FFFF");
        CNamedColors.add("DarkBlue", "#00008B");
        CNamedColors.add("DarkCyan", "#008B8B");
        CNamedColors.add("DarkGoldenRod", "#B8860B");
        CNamedColors.add("DarkGray", "#A9A9A9");
        CNamedColors.add("DarkGrey", "#A9A9A9");
        CNamedColors.add("DarkGreen", "#006400");
        CNamedColors.add("DarkKhaki", "#BDB76B");
        CNamedColors.add("DarkMagenta", "#8B008B");
        CNamedColors.add("DarkOliveGreen", "#556B2F");
        CNamedColors.add("DarkOrange", "#FF8C00");
        CNamedColors.add("DarkOrchid", "#9932CC");
        CNamedColors.add("DarkRed", "#8B0000");
        CNamedColors.add("DarkSalmon", "#E9967A");
        CNamedColors.add("DarkSeaGreen", "#8FBC8F");
        CNamedColors.add("DarkSlateBlue", "#483D8B");
        CNamedColors.add("DarkSlateGray", "#2F4F4F");
        CNamedColors.add("DarkSlateGrey", "#2F4F4F");
        CNamedColors.add("DarkTurquoise", "#00CED1");
        CNamedColors.add("DarkViolet", "#9400D3");
        CNamedColors.add("DeepPink", "#FF1493");
        CNamedColors.add("DeepSkyBlue", "#00BFFF");
        CNamedColors.add("DimGray", "#696969");
        CNamedColors.add("DimGrey", "#696969");
        CNamedColors.add("DodgerBlue", "#1E90FF");
        CNamedColors.add("FireBrick", "#B22222");
        CNamedColors.add("FloralWhite", "#FFFAF0");
        CNamedColors.add("ForestGreen", "#228B22");
        CNamedColors.add("Fuchsia", "#FF00FF");
        CNamedColors.add("Gainsboro", "#DCDCDC");
        CNamedColors.add("GhostWhite", "#F8F8FF");
        CNamedColors.add("Gold", "#FFD700");
        CNamedColors.add("GoldenRod", "#DAA520");
        CNamedColors.add("Gray", "#808080");
        CNamedColors.add("Grey", "#808080");
        CNamedColors.add("Green", "#008000");
        CNamedColors.add("GreenYellow", "#ADFF2F");
        CNamedColors.add("HoneyDew", "#F0FFF0");
        CNamedColors.add("HotPink", "#FF69B4");
        CNamedColors.add("IndianRed", "#CD5C5C");
        CNamedColors.add("Indigo", "#4B0082");
        CNamedColors.add("Ivory", "#FFFFF0");
        CNamedColors.add("Khaki", "#F0E68C");
        CNamedColors.add("Lavender", "#E6E6FA");
        CNamedColors.add("LavenderBlush", "#FFF0F5");
        CNamedColors.add("LawnGreen", "#7CFC00");
        CNamedColors.add("LemonChiffon", "#FFFACD");
        CNamedColors.add("LightBlue", "#ADD8E6");
        CNamedColors.add("LightCoral", "#F08080");
        CNamedColors.add("LightCyan", "#E0FFFF");
        CNamedColors.add("LightGoldenRodYellow", "#FAFAD2");
        CNamedColors.add("LightGray", "#D3D3D3");
        CNamedColors.add("LightGrey", "#D3D3D3");
        CNamedColors.add("LightGreen", "#90EE90");
        CNamedColors.add("LightPink", "#FFB6C1");
        CNamedColors.add("LightSalmon", "#FFA07A");
        CNamedColors.add("LightSeaGreen", "#20B2AA");
        CNamedColors.add("LightSkyBlue", "#87CEFA");
        CNamedColors.add("LightSlateGray", "#778899");
        CNamedColors.add("LightSlateGrey", "#778899");
        CNamedColors.add("LightSteelBlue", "#B0C4DE");
        CNamedColors.add("LightYellow", "#FFFFE0");
        CNamedColors.add("Lime", "#00FF00");
        CNamedColors.add("LimeGreen", "#32CD32");
        CNamedColors.add("Linen", "#FAF0E6");
        CNamedColors.add("Magenta", "#FF00FF");
        CNamedColors.add("Maroon", "#800000");
        CNamedColors.add("MediumAquaMarine", "#66CDAA");
        CNamedColors.add("MediumBlue", "#0000CD");
        CNamedColors.add("MediumOrchid", "#BA55D3");
        CNamedColors.add("MediumPurple", "#9370DB");
        CNamedColors.add("MediumSeaGreen", "#3CB371");
        CNamedColors.add("MediumSlateBlue", "#7B68EE");
        CNamedColors.add("MediumSpringGreen", "#00FA9A");
        CNamedColors.add("MediumTurquoise", "#48D1CC");
        CNamedColors.add("MediumVioletRed", "#C71585");
        CNamedColors.add("MidnightBlue", "#191970");
        CNamedColors.add("MintCream", "#F5FFFA");
        CNamedColors.add("MistyRose", "#FFE4E1");
        CNamedColors.add("Moccasin", "#FFE4B5");
        CNamedColors.add("NavajoWhite", "#FFDEAD");
        CNamedColors.add("Navy", "#000080");
        CNamedColors.add("OldLace", "#FDF5E6");
        CNamedColors.add("Olive", "#808000");
        CNamedColors.add("OliveDrab", "#6B8E23");
        CNamedColors.add("Orange", "#FFA500");
        CNamedColors.add("OrangeRed", "#FF4500");
        CNamedColors.add("Orchid", "#DA70D6");
        CNamedColors.add("PaleGoldenRod", "#EEE8AA");
        CNamedColors.add("PaleGreen", "#98FB98");
        CNamedColors.add("PaleTurquoise", "#AFEEEE");
        CNamedColors.add("PaleVioletRed", "#DB7093");
        CNamedColors.add("PapayaWhip", "#FFEFD5");
        CNamedColors.add("PeachPuff", "#FFDAB9");
        CNamedColors.add("Peru", "#CD853F");
        CNamedColors.add("Pink", "#FFC0CB");
        CNamedColors.add("Plum", "#DDA0DD");
        CNamedColors.add("PowderBlue", "#B0E0E6");
        CNamedColors.add("Purple", "#800080");
        CNamedColors.add("RebeccaPurple", "#663399");
        CNamedColors.add("Red", "#FF0000");
        CNamedColors.add("RosyBrown", "#BC8F8F");
        CNamedColors.add("RoyalBlue", "#4169E1");
        CNamedColors.add("SaddleBrown", "#8B4513");
        CNamedColors.add("Salmon", "#FA8072");
        CNamedColors.add("SandyBrown", "#F4A460");
        CNamedColors.add("SeaGreen", "#2E8B57");
        CNamedColors.add("SeaShell", "#FFF5EE");
        CNamedColors.add("Sienna", "#A0522D");
        CNamedColors.add("Silver", "#C0C0C0");
        CNamedColors.add("SkyBlue", "#87CEEB");
        CNamedColors.add("SlateBlue", "#6A5ACD");
        CNamedColors.add("SlateGray", "#708090");
        CNamedColors.add("SlateGrey", "#708090");
        CNamedColors.add("Snow", "#FFFAFA");
        CNamedColors.add("SpringGreen", "#00FF7F");
        CNamedColors.add("SteelBlue", "#4682B4");
        CNamedColors.add("Tan", "#D2B48C");
        CNamedColors.add("Teal", "#008080");
        CNamedColors.add("Thistle", "#D8BFD8");
        CNamedColors.add("Tomato", "#FF6347");
        CNamedColors.add("Turquoise", "#40E0D0");
        CNamedColors.add("Violet", "#EE82EE");
        CNamedColors.add("Wheat", "#F5DEB3");
        CNamedColors.add("White", "#FFFFFF");
        CNamedColors.add("WhiteSmoke", "#F5F5F5");
        CNamedColors.add("Yellow", "#FFFF00");
        CNamedColors.add("YellowGreen", "#9ACD32");
    }
}

