/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.color;

import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilIntegerArray;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.swing.color.CNamedColor;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilColor {
    public static final String ALPHA = "alpha";
    public static final String BLUE = "blue";
    public static final String GREEN = "green";
    public static final String RED = "red";
    public static final int MAX_ALPHA = 255;
    public static final String NAME = "name";
    public static final String COLON = ",";
    private static final int MAX_BYTE = 255;
    private static final int IS_NULL = 0;
    private static final int IS_RGB = 1;
    private static final int ARRAY_SIZE = 4;
    private static final int MAX_COLOR = 255;
    private static final int RED_POS = 0;
    private static final int GREEN_POS = 1;
    private static final int BLUE_POS = 2;
    private static final int ALPHA_POS = 3;

    private CUtilColor() {
    }

    @NotNull
    public static Color fromStream(@NotNull DataInput aStream) throws IOException {
        Color color = Color.WHITE;
        CBitField bf = new CBitField(8);
        bf.fromStream(aStream, 1);
        if (!bf.get(0) && bf.get(1)) {
            byte[] arr = new byte[4];
            aStream.readFully(arr);
            int red = arr[0] & 0xFF;
            int green = arr[1] & 0xFF;
            int blue = arr[2] & 0xFF;
            int alpha = arr[3] & 0xFF;
            color = new Color(red, green, blue, alpha);
        }
        return color;
    }

    @NotNull
    public static Color fromString(@NotNull String aText) {
        return CUtilColor.fromString(aText, Color.WHITE);
    }

    @NotNull
    public static Color fromString(@NotNull String aText, @NotNull Color aDefault) {
        Color color = aDefault;
        CNamedColor namedColor = CNamedColors.get(aText);
        if (namedColor != null) {
            return namedColor.getColor(255);
        }
        int[] arr = CUtilIntegerArray.fromString(aText, COLON);
        if (arr.length == 4) {
            color = new Color(arr[0], arr[1], arr[2], arr[3]);
        }
        if (arr.length == 3) {
            color = new Color(arr[0], arr[1], arr[2], 255);
        }
        return color;
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable Color aColor) throws IOException {
        CBitField bf = new CBitField(8);
        bf.set(1, true);
        if (aColor != null) {
            bf.set(0, false);
            bf.toStreamWithoutLength(aStream);
            byte[] arr = new byte[4];
            int red = aColor.getRed();
            arr[0] = (byte)red;
            arr[1] = (byte)aColor.getGreen();
            arr[2] = (byte)aColor.getBlue();
            arr[3] = (byte)aColor.getAlpha();
            aStream.write(arr);
        } else {
            bf.set(0, true);
            bf.toStreamWithoutLength(aStream);
        }
    }

    public static String toString(Color aColor) {
        int[] arr = aColor == null ? new int[]{255, 255, 255, 255} : new int[]{aColor.getRed(), aColor.getGreen(), aColor.getBlue(), aColor.getAlpha()};
        return CUtilIntegerArray.toString(arr, ',', 0);
    }

    public static Color parseStringProperties(@NotNull CStringProperties aValue) {
        String name;
        int alpha = 255;
        String s = aValue.get(ALPHA, null);
        if (CUtilString.isValid(s)) {
            alpha = CUtilInteger.fromString(s, 255);
        }
        if ((name = aValue.get(NAME, null)) != null) {
            Color color = CUtilColor.fromString(name);
            if (alpha == 255) {
                return color;
            }
            return CUtilColor.setAlpha(color, alpha);
        }
        String redStr = aValue.get(RED, "0");
        int red = CUtilInteger.fromString(redStr);
        String greenStr = aValue.get(GREEN, "0");
        int green = CUtilInteger.fromString(greenStr);
        String blueStr = aValue.get(BLUE, "0");
        int blue = CUtilInteger.fromString(blueStr);
        return new Color(red, green, blue, alpha);
    }

    @NotNull
    public static Color setAlpha(@NotNull Color aColor, int aAlpha) {
        return new Color(aColor.getRed(), aColor.getGreen(), aColor.getBlue(), aAlpha);
    }

    public static int[] fromHexAsArray(@NotNull String aHex) {
        String hex;
        int[] result = new int[3];
        String string = hex = aHex.startsWith("#") ? aHex.substring(1) : aHex;
        if (hex.length() == 6) {
            String c1 = hex.substring(0, 2);
            String c2 = hex.substring(2, 4);
            String c3 = hex.substring(4);
            result[0] = Integer.valueOf(c1, 16);
            result[1] = Integer.valueOf(c2, 16);
            result[2] = Integer.valueOf(c3, 16);
        }
        return result;
    }

    @NotNull
    public static Color fromHex(@NotNull String aHex, int aAlpha) {
        int[] rgb = CUtilColor.fromHexAsArray(aHex);
        return new Color(rgb[0], rgb[1], rgb[2], aAlpha);
    }

    public static Color fromHexWithAlpha(@NotNull String aHex) {
        String[] split = aHex.split(COLON);
        int[] rgb = new int[]{0, 0, 0};
        int alpha = 255;
        if (split.length >= 1) {
            rgb = CUtilColor.fromHexAsArray(split[0]);
        }
        if (split.length >= 2) {
            alpha = Integer.parseInt(split[1]);
        }
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    @NotNull
    public static String toHex(@NotNull Color aColor) {
        return String.format("#%02X%02X%02X", aColor.getRed(), aColor.getGreen(), aColor.getBlue());
    }

    @NotNull
    public static String toHexWithAlpha(@NotNull Color aColor) {
        return CUtilColor.toHex(aColor) + COLON + aColor.getAlpha();
    }

    @NotNull
    public static Color random() {
        return new Color(CUtilRandom.getRandom().nextInt(256), CUtilRandom.getRandom().nextInt(256), CUtilRandom.getRandom().nextInt(256), 255);
    }

    public static void toHexWithAlpha() {
    }
}

