/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.tcp;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.tcp.CStreamInput;
import de.sillysky.nyssr.util.tcp.CStreamOutput;
import de.sillysky.nyssr.util.tcp.ITcpOwner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class CTcpConnection
implements Runnable {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpConnection.class);
    private static final byte[] HEADER = new byte[]{17, 34, 51, 68};
    private final AtomicBoolean mRunning = new AtomicBoolean();
    private final AtomicBoolean mStop = new AtomicBoolean();
    private final ITcpOwner mOwner;
    private final byte[] mBuffer;
    private final InputStream mIn;
    private final OutputStream mOut;
    private final Socket mSocket;
    private Thread mThread;
    private AtomicReference<CStreamOutput> mStreamOutput = new AtomicReference<Object>(null);

    public CTcpConnection(@NotNull ITcpOwner aOwner, int aBufSize, Socket aClientSocket) throws IOException {
        this.mOwner = aOwner;
        this.mSocket = aClientSocket;
        this.mBuffer = new byte[aBufSize];
        InputStream is = this.mSocket.getInputStream();
        this.mIn = new BufferedInputStream(is);
        OutputStream os = this.mSocket.getOutputStream();
        this.mOut = new BufferedOutputStream(os);
        this.mStreamOutput.set(new CStreamOutput(HEADER, this.mOut));
        this.mStop.set(false);
        this.mThread = new Thread((Runnable)this, "ConnectionProvider-" + String.valueOf(aClientSocket.getRemoteSocketAddress()));
        this.mThread.start();
    }

    @Override
    public void run() {
        LOG.debug("TcpConnection started: {}", this.toString());
        this.mRunning.set(true);
        CStreamInput input = new CStreamInput(this, HEADER, 1000000, this.mOwner);
        while (!this.mStop.get()) {
            try {
                int bytesRead = this.mIn.read(this.mBuffer);
                if (bytesRead <= 0) continue;
                input.put(this.mBuffer, 0, bytesRead);
            }
            catch (SocketException e) {
                LOG.debug("Socket closed {} {}", this.toString(), e.getMessage());
                this.mStop.set(true);
            }
            catch (Exception e) {
                LOG.error("Exception reading from Tcp: {} {}", this.toString(), e.getMessage());
                this.mStop.set(true);
            }
        }
        this.mStreamOutput = null;
        this.mRunning.set(false);
        LOG.debug("TcpConnection stopped: {}", this.toString());
        this.mThread = null;
    }

    public void close() {
        this.mStop.set(true);
        if (!this.mSocket.isClosed()) {
            InetAddress inetAddress = this.mSocket.getInetAddress();
            int port = this.mSocket.getPort();
            LOG.debug("Close connection socket for {}:{}.", inetAddress, port);
            try {
                this.mSocket.close();
                this.mStreamOutput.set(null);
                LOG.info("Connection socket for {}:{} closed.", inetAddress, port);
            }
            catch (IOException e) {
                LOG.error(e, "Error on closing Connection socket for {}:{}.", inetAddress, port);
            }
        }
    }

    public void send(byte[] aData) throws Exception {
        if (!this.mSocket.isConnected()) {
            throw new CException(5201).append("Socket closed.");
        }
        CStreamOutput output = this.mStreamOutput.get();
        if (output == null) {
            LOG.error("StreamOut is null.");
        } else {
            output.put(aData);
        }
    }
}

