/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.util.CUtilString;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilLocalDate {
    private CUtilLocalDate() {
    }

    @NotNull
    public static LocalDate fromInstant(@NotNull Instant aInstant) {
        return aInstant.atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Nullable
    public static LocalDate parseIsoLocalDate(@Nullable String aValue) {
        if (CUtilString.isValid(aValue)) {
            return LocalDate.parse(aValue);
        }
        return null;
    }

    @NotNull
    public static String toStringIsoLocalDate(@NotNull LocalDate aLocalDate) {
        return aLocalDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @NotNull
    public static LocalDate fromDate(@NotNull Date aDate) {
        return new java.sql.Date(aDate.getTime()).toLocalDate();
    }

    @Nullable
    public static LocalDate fromIsoString(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return null;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE;
        TemporalAccessor ta = dtf.parse(aValue);
        return LocalDate.from(ta);
    }

    @NotNull
    public static String valueToIsoString(@Nullable LocalDate aValue) {
        if (aValue == null) {
            return "";
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE;
        return dtf.format(aValue);
    }
}

