/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.gatekeeper.target;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.gatekeeper.IGateKeeperRule;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperAdd;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperAddRule;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperGetRuleList;
import de.sillysky.nyssr.gatekeeper.records.CRecordGateKeeperRemoveRule;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.network.gatekeeper.CGateKeeperRule;
import de.sillysky.nyssr.impl.network.gatekeeper.target.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.helper.CRecordHelper;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class CTargetForGateKeeper
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForGateKeeper.class);
    private final IDependencies mDependencies;

    CTargetForGateKeeper(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordGateKeeperAddRule.ID, this::asyncAddRule);
        this.addMessageHandler(CRecordGateKeeperRemoveRule.ID, this::asyncRemoveRule);
        this.addMessageHandler(CRecordGateKeeperGetRuleList.ID, this::asyncGetRuleList);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "Transport");
        ns.getTargetRegistry().registerTarget((ITarget)this, CWellKnownTID.GATEKEEPER);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecordHelper.addObserver(CRecordGateKeeperAddRule.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordGateKeeperRemoveRule.class, (ITarget)this, (boolean)false);
        CRecordHelper.addObserver(CRecordGateKeeperGetRuleList.class, (ITarget)this, (boolean)false);
        this.sendAddGateKeeper();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddRule(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (!this.getAddress().getNodeId().equals((Object)aEnvelope.getSender().getNodeId())) {
            aEnvelope.setResult(3, "Don't accept adding rules from outer space.");
            return true;
        }
        CRecord ruleRecord = CRecordGateKeeperAddRule.getRule((CRecord)aRecord, null);
        CGateKeeperRule rule = new CGateKeeperRule(ruleRecord);
        this.mDependencies.getGateKeeper().addRule((IGateKeeperRule)rule);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveRule(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        if (!this.getAddress().getNodeId().equals((Object)aEnvelope.getSender().getNodeId())) {
            aEnvelope.setResult(3, "Don't accept removing rules from outer space.");
            return true;
        }
        String description = CRecordGateKeeperRemoveRule.getDescription((CRecord)aRecord, null);
        if (CUtilString.isEmpty((String)description)) {
            aEnvelope.setResult(7, "Missing description.");
            return true;
        }
        this.mDependencies.getGateKeeper().removeRule(description);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetRuleList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Collection rules = this.mDependencies.getGateKeeper().getRules();
        CRecord[] records = new CRecord[rules.size()];
        int i = 0;
        for (IGateKeeperRule r : rules) {
            records[i] = ((CGateKeeperRule)r).ruleToRecord();
            ++i;
        }
        CRecordGateKeeperGetRuleList.setRuleList((CRecord)aRecord, (CRecord[])records);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.deregisterTarget();
    }

    private void sendAddGateKeeper() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordGateKeeperAdd.class);
        CRecord rec = CRecordGateKeeperAdd.create();
        CRecordGateKeeperAdd.setGateKeeper((CRecord)rec, (Object)this.mDependencies.getGateKeeper());
        this.sendNotification(env, rec);
    }
}

