/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.user.manager;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.app.user.manager.CApplicationContext;
import de.sillysky.nyssr.impl.app.user.manager.CMainTarget;
import de.sillysky.nyssr.impl.app.user.manager.CMessagePanelHolder;
import de.sillysky.nyssr.impl.app.user.manager.IDependencies;
import de.sillysky.nyssr.impl.app.user.manager.ILocalAppContext;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.EPlatformType;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.widgetset.loader.IWidgetSetLoader;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CApp
extends CTarget
implements ILocalAppContext {
    private static final String[] JSON = new String[]{"/json/800_Main.json"};
    private final IDependencies mDependencies;
    private final IId mContextId = CIdFactory.fromObject((Object)("UserManager_" + String.valueOf(UUID.randomUUID())));
    private CApplicationContext mApplicationContext;
    private IRemoteSkinServerContext mServerContext;
    private IRemoteSkinClientContext mClientContext;
    private CMessagePanelHolder mMessagePanel;

    public CApp(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
    }

    @Override
    public CMessagePanelHolder getMessagePanel() {
        return this.mMessagePanel;
    }

    @Override
    public void setMessagePanel(CMessagePanelHolder aMessagePanel) {
        this.mMessagePanel = aMessagePanel;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        INamespace ns = this.mApplicationContext.getNamespace();
        CNodeAddress remoteSkinClient = this.mApplicationContext.getClientRemoteSkinAddress();
        if (remoteSkinClient != null && ns != null) {
            this.mServerContext = this.mDependencies.getServerContextFactory().createContext(ns.getNID());
            this.mServerContext.startContext(this.mContextId, remoteSkinClient, EPlatformType.SWING.name(), this::notifyClientContextStarted);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void notifyClientContextStarted(@NotNull IRemoteSkinClientContext aRemoteSkinClientContext, int aResultCode, @Nullable String aResultText) throws CException {
        if (aResultCode == 0) {
            this.mClientContext = aRemoteSkinClientContext;
            this.sendJsonFiles();
            CMainTarget mainTarget = new CMainTarget(this);
            this.getTargetRegistry().registerTarget((ITarget)mainTarget);
        }
    }

    void start(@NotNull CApplicationContext aContext) throws Exception {
        this.mApplicationContext = aContext;
        INamespace namespace = this.mApplicationContext.getNamespace();
        CUtilCheck.checkNotNull((Object)namespace, (String)"Namespace missing", (Object[])new Object[0]);
        namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    @Override
    public CApplicationContext getApplicationContext() {
        return this.mApplicationContext;
    }

    @Override
    public IDependencies getDependencies() {
        return this.mDependencies;
    }

    @Override
    public IRemoteSkinClientContext getClientContext() {
        return this.mClientContext;
    }

    @Override
    public IRemoteSkinServerContext getServerContext() {
        return this.mServerContext;
    }

    private void sendJsonFiles() throws CException {
        IWidgetSetLoader loader = this.mDependencies.getWidgetSetLoader();
        ArrayList<String> jsonList = new ArrayList<String>();
        Class<?> clazz = this.getClass();
        for (String s : JSON) {
            String json = loader.loadJson(clazz, s);
            jsonList.add(json);
        }
        this.mServerContext.pushWidgetSets(jsonList, null);
    }
}

