/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.tcp.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordTcpCreateClientRetry
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"ef1cf2a3-b501-404a-8545-394ae5b7a514");
    public static final String NAME = "TcpCreateClientRetry";
    public static final String DESCRIPTION = "Begin of a new retry period for client connection.";
    public static final String SLOT_ID = "1";
    public static final String SLOT_RETRY_COUNT = "3";
    public static final String SLOT_TIMEOUT = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static int getRetryCount(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RETRY_COUNT);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static long getTimeout(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIMEOUT);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setRetryCount(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_RETRY_COUNT, slot);
    }

    public static void setTimeout(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_TIMEOUT, slot);
    }
}

