/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.tcp.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordTcpServer
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"c3ce266b-011a-4424-8270-c423b58802a2");
    public static final String NAME = "TcpServer";
    public static final String DESCRIPTION = "A TCP server.";
    public static final String SLOT_ID = "1";
    public static final String SLOT_INPUT_BUFFER_SIZE = "6";
    public static final String SLOT_PORT = "2";
    public static final String SLOT_TLS_CIPHER_SUITES = "5";
    public static final String SLOT_TLS_ENABLED = "3";
    public static final String SLOT_TLS_PROTOCOLS = "4";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static int getInputBufferSize(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INPUT_BUFFER_SIZE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static int getPort(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PORT);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static String getTlsCipherSuites(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_CIPHER_SUITES);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static boolean getTlsEnabled(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_ENABLED);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getTlsProtocols(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TLS_PROTOCOLS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setInputBufferSize(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_INPUT_BUFFER_SIZE, slot);
    }

    public static void setPort(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_PORT, slot);
    }

    public static void setTlsCipherSuites(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_CIPHER_SUITES, slot);
    }

    public static void setTlsEnabled(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_ENABLED, slot);
    }

    public static void setTlsProtocols(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_TLS_PROTOCOLS, slot);
    }
}

