/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.bridgehead;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.network.transport.ITransport;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.microservice.collector.IMicroServiceRegistryCollector;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryDeleted;
import de.sillysky.nyssr.microservice.registry.records.CRecordForwardToMicroServiceInstance;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceIds;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceInstance;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceInstances;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServices;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastTransportMsg;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

public class CBridgeHeadTarget
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CBridgeHeadTarget.class);
    private static final IId[] MICRO_SERVICE_REGISTRY = new IId[]{CRecordForwardToMicroServiceInstance.ID, CRecordGetMicroServiceIds.ID, CRecordGetMicroServiceInstance.ID, CRecordGetMicroServiceInstances.ID, CRecordGetMicroServices.ID};
    private static final IId[] BROADCASTS = new IId[]{CRecordBroadcastMicroServiceRegistryCreated.ID, CRecordBroadcastMicroServiceRegistryDeleted.ID, CRecordBroadcastSendMsg.ID, CRecordBroadcastTransportMsg.ID};
    private final ITransport mTransport;
    private final IMicroServiceRegistryCollector mMicroServiceRegistryCollector;
    private final INodeInfoDatabase mNodeInfoDatabase;

    public CBridgeHeadTarget(@NotNull ITransport aTransport, @NotNull IMicroServiceRegistryCollector aMicroServiceRegistryCollector, @NotNull INodeInfoDatabase aNodeInfoDatabase) {
        this.mTransport = aTransport;
        this.mMicroServiceRegistryCollector = aMicroServiceRegistryCollector;
        this.mNodeInfoDatabase = aNodeInfoDatabase;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(null, this::asyncOther);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncOther(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return true;
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean isIdInArray(@NotNull IId aId, @NotNull IId[] aIds) {
        for (IId id : aIds) {
            if (!id.equals((Object)aId)) continue;
            return true;
        }
        return false;
    }

    private boolean isForMicroServiceRegistry(@NotNull IId aId) {
        return this.isIdInArray(aId, MICRO_SERVICE_REGISTRY);
    }

    private boolean isBroadCast(@NotNull IId aId) {
        return this.isIdInArray(aId, BROADCASTS);
    }

    public void forwardMessage(@NotNull CNodeAddress aRemoteNode, @NotNull CMessage aMessage) throws CException {
        CEnvelope env = aMessage.getEnvelope();
        IId id = aMessage.getRecord().getId();
        if (this.isForMicroServiceRegistry(id)) {
            CTargetAddress nextAddress = this.mMicroServiceRegistryCollector.getNextAddress();
            if (nextAddress != null) {
                LOG.debug("Forward Message to MicroServiceRegistry {}", new Object[]{id});
                env.setReceiver(nextAddress);
                this.sendNotification(aMessage);
            }
            return;
        }
        CNodeInfoDto nodeInfo = this.mNodeInfoDatabase.getNodeInfo(env.getReceiver().getNodeAddress());
        if (nodeInfo == null || !nodeInfo.isClient() && this.isBroadCast(id)) {
            LOG.debug("Drop Message {}", new Object[]{id});
            return;
        }
        LOG.debug("Forward Message {}", new Object[]{id});
        this.getMessageSender().send(aMessage);
    }
}

