/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionFirstDataDto;
import de.sillysky.nyssr.impl.network.connection.registry.CConstants;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CConnectionFirstDataUtil {
    private CConnectionFirstDataUtil() {
    }

    @Nullable
    public static CConnectionFirstDataDto fromStream(@NotNull InputStream aStream, @NotNull Collection<CNodeId> aForbiddenNodeIds) throws CException, IOException {
        DataInputStream dis = new DataInputStream(aStream);
        try {
            int size = aStream.available();
            if (size >= 200) {
                dis.mark(200);
                CConnectionFirstDataDto dto = new CConnectionFirstDataDto();
                CConnectionFirstDataUtil.readHeader(dis, dto);
                CConnectionFirstDataUtil.readInstanceID(dis, dto);
                CConnectionFirstDataUtil.readConnectionID(dis, dto);
                CConnectionFirstDataUtil.readNodeId(dis, dto, aForbiddenNodeIds);
                CConnectionFirstDataUtil.readSegmentId(dis, dto);
                CConnectionFirstDataUtil.readNodeType(dis, dto);
                CConnectionFirstDataUtil.readLicense(dis, dto);
                CConnectionFirstDataUtil.readPacketBuilderSequence(dis, dto);
                CConnectionFirstDataUtil.readName(dis, dto);
                CConnectionFirstDataUtil.readDescription(dis, dto);
                return dto;
            }
        }
        catch (IOException e1) {
            CConnectionFirstDataUtil.resetStream(dis);
            throw e1;
        }
        return null;
    }

    private static void resetStream(@NotNull DataInputStream aDis) throws CException {
        try {
            aDis.reset();
        }
        catch (IOException e2) {
            throw new CException(2101).append("Can't reset connection stream.");
        }
    }

    private static void readNodeId(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto, @NotNull Collection<CNodeId> aForbiddenNodeIds) throws IOException, CException {
        CNodeId nodeId = CNodeId.fromStream((DataInput)aDis);
        if (nodeId == null || !nodeId.isValid()) {
            throw new CException(5302).append("NodeId is empty. Connection dismissed.");
        }
        aDto.setNodeId(nodeId);
        CNodeId remoteNodeId = aDto.getNodeId();
        if (aForbiddenNodeIds.contains(remoteNodeId)) {
            throw new CException(5301).append("Remote NodeId equals Local NodeId. Connection dismissed.");
        }
    }

    private static void readSegmentId(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        CSegmentId segmentId = CSegmentId.fromStream((DataInput)aDis);
        if (segmentId == null || !segmentId.isValid()) {
            throw new CException(5303).append("SegmentId is empty. Connection dismissed.");
        }
        aDto.setSegmentId(segmentId);
    }

    private static void readInstanceID(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        UUID instanceId = CUtilUuid.nonNullFromStream((DataInput)aDis);
        if (CUtilUuid.isEmpty((UUID)instanceId)) {
            throw new CException(28).append("InstanceId is empty. Connection dismissed.");
        }
        aDto.setInstanceId(instanceId);
    }

    private static void readConnectionID(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        UUID connectionId = CUtilUuid.nonNullFromStream((DataInput)aDis);
        if (CUtilUuid.isEmpty((UUID)connectionId)) {
            throw new CException(32).append("ConnectionId is empty. Connection dismissed.");
        }
        aDto.setConnectionId(connectionId);
    }

    private static void readLicense(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        UUID license = CUtilUuid.nonNullFromStream((DataInput)aDis);
        if (CUtilUuid.isEmpty((UUID)license)) {
            throw new CException(5310).append("LicenseId is empty. Connection dismissed.");
        }
        aDto.setLicense(license);
    }

    private static void readName(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        String name = CUtilString.fromStream((DataInput)aDis);
        if (CUtilString.isEmpty((String)name)) {
            throw new CException(5308).append("Node Name is empty. Connection dismissed.");
        }
        aDto.setName(name);
    }

    private static void readPacketBuilderSequence(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        aDto.setPackageBuilderSequence(CUtilString.fromStream((DataInput)aDis));
        if (CUtilString.isEmpty((String)aDto.getPackageBuilderSequence())) {
            throw new CException(5311).append("Node packet builder sequence is empty. Connection dismissed.");
        }
    }

    private static void readDescription(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException {
        aDto.setDescription(CUtilString.fromStream((DataInput)aDis));
    }

    private static void readNodeType(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        String s = CUtilString.fromStream((DataInput)aDis);
        ETypeOfNode typeOfNode = (ETypeOfNode)CUtilEnum.fromString(ETypeOfNode.class, (String)s, null);
        if (typeOfNode == null) {
            throw new CException(5309).append("No valid type of Node. Connection dismissed.");
        }
        aDto.setTypeOfNode(typeOfNode);
    }

    private static void readHeader(@NotNull DataInputStream aDis, @NotNull CConnectionFirstDataDto aDto) throws IOException, CException {
        aDto.setHeader(CUtilUuid.nonNullFromStream((DataInput)aDis));
        if (!CConstants.STREAM_HEADER.equals(aDto.getHeader())) {
            throw new CException(2102).append("HeaderId wrong. Connection dismissed.");
        }
    }

    public static byte @NotNull [] toByteArray(@NotNull CConnectionFirstDataDto aDto) throws IOException {
        ByteArrayOutputStream s1 = new ByteArrayOutputStream();
        DataOutputStream s2 = new DataOutputStream(s1);
        CUtilUuid.nonNullToStream((DataOutput)s2, (UUID)CConstants.STREAM_HEADER);
        CUtilUuid.nonNullToStream((DataOutput)s2, (UUID)aDto.getInstanceId());
        CUtilUuid.nonNullToStream((DataOutput)s2, (UUID)aDto.getConnectionId());
        CNodeId.toStream((DataOutput)s2, (CNodeId)aDto.getNodeId());
        CSegmentId.toStream((DataOutput)s2, (CSegmentId)aDto.getSegmentId());
        CUtilString.toStream((DataOutput)s2, (String)aDto.getTypeOfNode().name());
        CUtilUuid.nonNullToStream((DataOutput)s2, (UUID)aDto.getLicense());
        String pbs = aDto.getPackageBuilderSequence();
        CUtilString.toStream((DataOutput)s2, (String)(CUtilString.isEmpty((String)pbs) ? "M" : pbs));
        CUtilString.toStream((DataOutput)s2, (String)aDto.getName());
        CUtilString.toStream((DataOutput)s2, (String)aDto.getDescription());
        int size = s1.size();
        CUtilCheck.checkTrue((size <= 200 ? 1 : 0) != 0, (String)"NodeId or SegmentId too long, Stream Header exceeds 200 bytes", (Object[])new Object[0]);
        int paddingLength = 200 - size;
        byte[] padding = CUtilByteArray.createFilled((int)paddingLength, (byte)0);
        s2.write(padding);
        s2.close();
        return s1.toByteArray();
    }
}

