/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.connection.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionFirstDataDto;
import de.sillysky.nyssr.impl.network.connection.registry.CConnectionFirstDataUtil;
import de.sillysky.nyssr.impl.network.connection.registry.IDependencies;
import de.sillysky.nyssr.impl.network.connection.registry.records.CRecordConnectionValidated;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.kernel.records.CRecordDismiss;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.connection.dto.CConnectionDto;
import de.sillysky.nyssr.network.connection.dto.CConnectionUtil;
import de.sillysky.nyssr.network.connection.dto.EConnectionUsage;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.records.CRecordNetworkDataForRemote;
import de.sillysky.nyssr.network.records.CRecordNetworkDataFromRemote;
import de.sillysky.nyssr.network.transport.records.CRecordConnectionRead;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.bytecarousel.CByteCarousel;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CTransportPrimer
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransportPrimer.class);
    private static final String LINE = CUtilString.create((char)'#', (int)119) + "\n";
    private final IDependencies mDependencies;
    private final CConnectionDto mConnection;
    private final CTargetAddress mOwner;
    private final CByteCarousel mByteCarousel = new CByteCarousel();

    CTransportPrimer(@NotNull IDependencies aDependencies, @NotNull CTargetAddress aOwner, @NotNull CConnectionDto aConnection) {
        this.mDependencies = aDependencies;
        this.mConnection = aConnection;
        this.mOwner = aOwner;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkDataFromRemote.ID, this::asyncDataFromRemote);
        this.addMessageHandler(CRecordConnectionValidated.ID, this::asyncAnswerConnectionValidated);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendStartReceiving();
        if (!this.mConnection.isIncoming()) {
            this.sendHeader();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDataFromRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws IOException, CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] data = CRecordNetworkDataFromRemote.getData((CRecord)aRecord, null);
        if (data != null) {
            this.mByteCarousel.getOutputStream().write(data);
            UUID connectionId = this.tryToValidateStream();
            if (connectionId != null) {
                CRecordNetworkDataFromRemote.setConnectionId((CRecord)aRecord, (UUID)connectionId);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerConnectionValidated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return aEnvelope.isAnswer();
    }

    private void sendStartReceiving() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
        CRecord rec = CRecordConnectionRead.create();
        CRecordConnectionRead.setLength((CRecord)rec, (int)200);
        this.sendNotification(env, rec);
    }

    private void sendDismissToConnection() throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
        CRecord rec = CRecordDismiss.create();
        this.sendNotification(env, rec);
    }

    private void sendPacketToTransportLayer(byte[] aData) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mConnection.getConnectionAddress());
        env.setLogEnabled(false);
        CRecord rec = CRecordNetworkDataForRemote.create();
        CRecordNetworkDataForRemote.setData((CRecord)rec, (byte[])aData);
        this.sendNotification(env, rec);
    }

    @Nullable
    private UUID tryToValidateStream() throws CException {
        HashSet<CNodeId> forbidden = new HashSet<CNodeId>();
        forbidden.add(CNodeId.getLocal());
        try {
            CConnectionFirstDataDto dto = CConnectionFirstDataUtil.fromStream(this.mByteCarousel.getInputStream(), forbidden);
            if (dto != null) {
                CNodeAddress na = new CNodeAddress(dto.getNodeId(), dto.getSegmentId());
                CNodeInfoDto info = new CNodeInfoDto(na, dto.getInstanceId());
                info.setLicense(dto.getLicense());
                info.setName(dto.getName());
                info.setDescription(dto.getDescription());
                info.setTypeOfNode(dto.getTypeOfNode());
                info.setHisPacketBuilderSequence(dto.getPackageBuilderSequence());
                this.mDependencies.getNodeInfoDatabase().updateNodeInfo(info);
                this.mConnection.setId(dto.getConnectionId());
                this.setValidated(na, dto.getInstanceId());
                return dto.getConnectionId();
            }
        }
        catch (IOException aE1) {
            LOG.debug("Not enough data");
        }
        catch (CException aE2) {
            this.sendDismissToConnection();
            this.deregisterTarget();
        }
        return null;
    }

    public void notifyTargetDeRegistered() {
        super.notifyTargetDeRegistered();
        LOG.info("ByteCarousel TransportPrimer: Data = " + this.mByteCarousel.getAvailableRead());
    }

    private void setValidated(@NotNull CNodeAddress aNodeAddress, @NotNull UUID aInstanceId) throws CException, IOException {
        StringBuilder sb = new StringBuilder(500);
        sb.append(LINE);
        sb.append("# Remote Node   ");
        sb.append(aNodeAddress);
        sb.append(CUtilString.CRLF);
        sb.append("# Instance      ");
        sb.append(aInstanceId);
        sb.append(CUtilString.CRLF);
        sb.append(LINE);
        LOG.info(sb.toString());
        CNodeInfoDto nodeInfo = this.mDependencies.getNodeInfoDatabase().getOrCreateNodeRecord(aNodeAddress);
        nodeInfo.resetIfOtherInstanceId(aInstanceId);
        if (this.mConnection.isIncoming()) {
            this.sendHeader();
        }
        this.sendConnectionValidated(aNodeAddress, aInstanceId);
        this.deregisterTarget();
    }

    private void sendHeader() throws CException, IOException {
        IKernelConfiguration kc = this.mDependencies.getKernelConfiguration();
        CConnectionFirstDataDto dto = new CConnectionFirstDataDto();
        dto.setInstanceId(kc.getInstanceId());
        dto.setConnectionId(kc.getInstanceId());
        dto.setConnectionId(this.mConnection.getID());
        dto.setNodeId(CNodeId.getLocal());
        dto.setSegmentId(CSegmentId.getLocal());
        dto.setLicense(kc.getLicense());
        dto.setName(kc.getName());
        dto.setDescription(kc.getDescription());
        dto.setTypeOfNode(kc.getTypeOfNode());
        dto.setPackageBuilderSequence(this.mDependencies.getNodeInfoDatabase().getMyPacketBuilderSequence());
        byte[] bb = CConnectionFirstDataUtil.toByteArray(dto);
        this.sendPacketToTransportLayer(bb);
    }

    private void sendConnectionValidated(@NotNull CNodeAddress aRemoteNodeAddress, @NotNull UUID aRemoteInstanceId) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mOwner);
        CRecord rec = CRecordConnectionValidated.create();
        this.mConnection.setRemoteNodeAddress(aRemoteNodeAddress);
        this.mConnection.setRemoteInstanceID(aRemoteInstanceId);
        this.mConnection.setUsage(EConnectionUsage.MESSAGING);
        CRecord inner = CConnectionUtil.toRecord(this.mConnection);
        CRecordConnectionValidated.setConnection(rec, inner);
        this.sendNotification(env, rec);
    }
}

