/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.hints.routing;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.hints.routing.CRoutingHintList;
import de.sillysky.nyssr.impl.network.hints.routing.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.hints.IRoutingHintRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilLong;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CServiceRoutingHints
extends CTarget
implements IService,
IRoutingHintRegistry {
    public static AtomicLong mForgetAfterMinutes = new AtomicLong(1440L);
    public static AtomicLong mCheckAfterMinutes = new AtomicLong(60L);
    private static final IId TIMER = CIdFactory.fromObject((Object)"Timer");
    private final IDependencies mDependencies;
    private final CRoutingHintList mHints = new CRoutingHintList();
    private CTimer mTimer;

    public CServiceRoutingHints(IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(TIMER, this::asyncTimer);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
        String s = preferences.get("network.routing.hint.forget.after.minutes", null);
        long l = CUtilLong.fromString((String)s, (long)1440L);
        mForgetAfterMinutes.set(l);
        s = preferences.get("network.routing.hint.check.after.minutes", null);
        l = CUtilLong.fromString((String)s, (long)60L);
        mCheckAfterMinutes.set(l);
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "Transport");
        ns.getTargetRegistry().registerTarget((ITarget)this);
        aServiceRegistry.registerService(IRoutingHintRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mTimer.dismiss();
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    public void add(@NotNull CRoutingHint aRoutingHint) {
        this.mHints.add(aRoutingHint);
    }

    @Nullable
    public CNodeId getBridgeNode(@NotNull CNodeAddress aAddressOfUnknownNode) {
        return this.mHints.getBridgeNode(aAddressOfUnknownNode);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aCRecord) {
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER, this.getAddress(), mCheckAfterMinutes.get() * 1000L * 60L, false, null);
        this.mTimer.startIf();
        return true;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aCRecord) {
        this.mTimer.notifyTriggerOccurred();
        this.mHints.checkExpiration();
        this.mTimer.startIf();
        return true;
    }
}

