/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.index.target.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexNotifyAvailable;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CNetworkIndexApiTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNetworkIndexApiTarget.class);
    @NotNull
    private final IDependencies mDependencies;

    CNetworkIndexApiTarget(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkIndexNotifyAvailable.ID, this::asyncNotifyNetworkIndexAvailable);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        ITargetRegistry tr = this.mDependencies.getNamespace().getTargetRegistry();
        tr.registerTarget((ITarget)this);
    }

    private boolean asyncNotifyNetworkIndexAvailable(CEnvelope aEnvelope, CRecord aRecord) {
        boolean available = CRecordNetworkIndexNotifyAvailable.getAvailable((CRecord)aRecord, (boolean)false);
        CTargetAddress address = CRecordNetworkIndexNotifyAvailable.getAddress((CRecord)aRecord, null);
        if (available) {
            this.mDependencies.getInternalNetworkIndex().registerNetworkIndex(address);
            LOG.debug("Network Index {} available", new Object[]{address});
        } else {
            this.mDependencies.getInternalNetworkIndex().deregisterNetworkIndex(address);
            LOG.debug("Network Index {} not available", new Object[]{address});
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mDependencies.getInternalNetworkIndex().setTarget((ITarget)this);
        this.mDependencies.getRecordHelper().addObserver(CRecordNetworkIndexNotifyAvailable.class, (ITarget)this, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mDependencies.getInternalNetworkIndex().setTarget(null);
        this.mDependencies.getRecordHelper().removeObserver(CRecordNetworkIndexNotifyAvailable.class, (ITarget)this);
        INanoServiceRegistry sr = this.mDependencies.getNamespace().getNanoServiceRegistry();
        sr.removeObserver(CRecordNetworkIndexNotifyAvailable.ID, this.getAddress());
        this.deregisterTarget();
    }
}

