/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.message.forwarder;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.router.IRouter;
import de.sillysky.nyssr.network.transport.records.CRecordForwardMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

public class CMessageForwarderTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CMessageForwarderTarget.class);
    private INamespaceFactory mNamespaceFactory;
    private IRouter mRouter;

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordForwardMessage.ID, this::asyncForwardMessage);
        this.mRouter = (IRouter)aServiceRegistry.getServiceOrThrow(IRouter.class);
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "Transport");
        ns.getTargetRegistry().registerTarget((ITarget)this, CWellKnownTID.MESSAGE_FORWARDER);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Start ForwardMessageTarget.");
        INamespace ns = this.mNamespaceFactory.getNamespace(CWellKnownNID.SYSTEM);
        ns.getNanoServiceRegistry().addObserver(CRecordForwardMessage.ID, this.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncForwardMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMessage message = CRecordForwardMessage.getMessage((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)message, (String)"Missing message", (Object[])new Object[0]);
        CNodeAddress destination = message.getEnvelope().getReceiver().getNodeAddress();
        CNodeAddress nextNode = this.mRouter.getNextNode(destination, true);
        if (nextNode != null) {
            LOG.debug("{}: Forward Message to Destination: Msg={}", new Object[]{CNodeId.getLocal(), message});
            this.getMessageSender().send(message);
        } else if (message.getEnvelope().getSender().getSegmentId().isLocal()) {
            LOG.warn("{}: Can't forward Message to Destination (no Route found, send back): Msg={}", new Object[]{CNodeId.getLocal(), message});
            this.getMessageSender().sendBack(message);
        } else {
            LOG.warn("{}: Can't forward Message to Destination (no Route found, drop): Msg={}", new Object[]{CNodeId.getLocal(), message});
        }
        aEnvelope.setResultSuccess();
        return true;
    }
}

