/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.factory.ping;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.packets.CPacketConstants;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class CPacketPing
implements IPacket {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketPing.class);
    private final boolean mIsAnswer;
    private final long mTimeSend;
    private byte[] mPayload;

    public CPacketPing(boolean aIsAnswer, long aTimeSend) {
        this.mIsAnswer = aIsAnswer;
        this.mTimeSend = aTimeSend;
    }

    @Override
    public byte[] getPayload() {
        return this.mPayload;
    }

    public long getTimeSend() {
        return this.mTimeSend;
    }

    @Override
    public EPacketType getType() {
        return EPacketType.PING;
    }

    public boolean isAnswer() {
        return this.mIsAnswer;
    }

    @Override
    public void pack() throws CException {
        try (ByteArrayOutputStream s1 = new ByteArrayOutputStream();
             DataOutputStream s2 = new DataOutputStream(s1);){
            s2.write(CPacketConstants.PACKET_HEADER);
            s2.write(this.getType().getValue());
            s2.writeBoolean(this.mIsAnswer);
            s2.writeLong(this.mTimeSend);
            s2.flush();
            this.mPayload = s1.toByteArray();
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Error on finishing packing: {}", new Object[]{this.toString()});
            throw new CException(2).append(e.getMessage());
        }
    }
}

