/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.router;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.router.CRouter;
import de.sillysky.nyssr.impl.network.router.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.nodeinfo.INodeInfoDatabase;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordDataNodeInfo;
import de.sillysky.nyssr.network.router.records.CRecordNetworkUpdateDirectLinks;
import de.sillysky.nyssr.record.CRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CDirectLinks {
    private final CRouter mRouter;
    private final Set<CNodeAddress> mNodes = new HashSet<CNodeAddress>();
    private final IDependencies mDependencies;
    private final Set<CNodeAddress> mClientNodes = new HashSet<CNodeAddress>();

    CDirectLinks(@NotNull IDependencies aDependencies, @NotNull CRouter aRouter) {
        this.mDependencies = aDependencies;
        this.mRouter = aRouter;
    }

    void add(@NotNull CNodeAddress aNodeAddress) throws CException {
        boolean added = this.mNodes.add(aNodeAddress);
        if (added) {
            CNodeInfoDto nodeRecord = this.mDependencies.getNodeInfoDatabase().getNodeInfo(aNodeAddress);
            if (nodeRecord != null && nodeRecord.isClient()) {
                this.mClientNodes.add(aNodeAddress);
            }
            this.broadCastDirectLinks();
        }
    }

    void remove(@NotNull CNodeAddress aNodeAddress) throws CException {
        boolean removed = this.mNodes.remove(aNodeAddress);
        this.mClientNodes.remove(aNodeAddress);
        if (removed) {
            this.broadCastDirectLinks();
        }
    }

    @NotNull
    Collection<CNodeAddress> getList(boolean aOnlyClients) {
        if (aOnlyClients) {
            return new ArrayList<CNodeAddress>(this.mClientNodes);
        }
        return new ArrayList<CNodeAddress>(this.mNodes);
    }

    @NotNull
    private CRecord[] getRecords(@NotNull INodeInfoDatabase aNodeInfoDatabase) throws CException {
        CRecord[] result = new CRecord[]{};
        if (!this.mNodes.isEmpty()) {
            ArrayList<CRecord> links = new ArrayList<CRecord>();
            for (CNodeAddress node : this.mNodes) {
                CNodeInfoDto info = aNodeInfoDatabase.getOrCreateNodeRecord(node);
                CRecord record = CRecordDataNodeInfo.create();
                info.toRecord(record);
                links.add(record);
            }
            result = links.toArray(result);
        }
        return result;
    }

    void broadCastDirectLinks() throws CException {
        if (this.mRouter.isUseNodeNeighborAnnouncement()) {
            CRecord[] links = this.getRecords(this.mDependencies.getNodeInfoDatabase());
            CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
            CRecord rec = CRecordNetworkUpdateDirectLinks.create();
            CRecordNetworkUpdateDirectLinks.setNode((CRecord)rec, (CNodeAddress)CNodeAddress.getLocal());
            CRecordNetworkUpdateDirectLinks.setDirectLinks((CRecord)rec, (CRecord[])links);
            this.mRouter.broadCast(env, rec, null);
        }
    }

    boolean isNeighbor(@NotNull CNodeAddress aNode) {
        return this.mClientNodes.contains(aNode);
    }
}

