/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.transport;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.transport.CConstants;
import de.sillysky.nyssr.impl.network.transport.IPrivateTransport;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.packets.CPacketConstants;
import de.sillysky.nyssr.network.packets.EPacketType;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketFactory;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.bytecarousel.CByteCarousel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTransportInputHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTransportInputHandler.class);
    private final IPrivateTransport mTransport;
    private final CByteCarousel mInputStream;
    private final boolean mIsTest = false;

    CTransportInputHandler(IPrivateTransport aTransport) {
        this.mTransport = aTransport;
        this.mInputStream = new CByteCarousel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIncomingData(byte[] aData) throws Exception {
        this.logIncomingBytes(aData);
        CByteCarousel cByteCarousel = this.mInputStream;
        synchronized (cByteCarousel) {
            this.mInputStream.getOutputStream().write(aData);
            this.readPackets();
        }
    }

    private void logIncomingBytes(byte[] aData) {
        if (CConstants.BYTE_LOG.isTraceEnabled()) {
            String string = CUtilByteArray.toString((byte[])aData, (char)',', (int)0);
            CConstants.BYTE_LOG.trace("Incoming {} bytes: {}", new Object[]{aData.length, string});
        }
    }

    private byte readHeader1(@NotNull DataInputStream aStream) throws IOException {
        for (byte element : CPacketConstants.PACKET_HEADER) {
            byte a = aStream.readByte();
            if (a == element) continue;
            return EPacketType.UNKNOWN.getValue();
        }
        return aStream.readByte();
    }

    @Nullable
    private IPacket readNextPacket(@NotNull DataInputStream aStream) {
        try {
            while (true) {
                IPacket p;
                int available;
                if ((available = aStream.available()) <= 4) {
                    return null;
                }
                aStream.mark(available);
                byte typeByte = this.readHeader1(aStream);
                EPacketType type = EPacketType.get(typeByte);
                if (type == EPacketType.UNKNOWN) {
                    LOG.error("Header1 not found, skip");
                    this.skipByte(aStream);
                    continue;
                }
                IPacketFactory factory = this.mTransport.getPacketFactoryRegistry().getPacketFactory(type);
                if (factory != null && (p = factory.fromStream(aStream, false)) != null) {
                    return p;
                }
                LOG.error("Unexpected Type {}, skip", new Object[]{type});
                this.skipByte(aStream);
            }
        }
        catch (IOException e) {
            this.resetStream(aStream);
            return null;
        }
    }

    private void readPackets() throws CException {
        IPacket packet;
        InputStream stream = this.mInputStream.getInputStream();
        DataInputStream dis = new DataInputStream(stream);
        do {
            if ((packet = this.readNextPacket(dis)) == null) continue;
            this.mTransport.getPacketConsumerRegistry().consume(this.mTransport, packet);
        } while (packet != null);
    }

    private void resetStream(@NotNull DataInputStream aStream) {
        try {
            aStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void skipByte(@NotNull DataInputStream aStream) throws IOException {
        aStream.reset();
        byte a = aStream.readByte();
    }
}

