package de.sillysky.nyssr.impl.example001;


import de.sillysky.nyssr.cli.ICommandLineInterface;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplExample001 implements IServiceStarter, IDependencies
{
    private IService mService;
    private INamespaceRegistry mNamespaceRegistry;

    @Override
    public void getDependencies(@NotNull final IServiceDependencyList aServiceDependencyList)
    {
        // Here we define the dependencies of our package
        // We need the namespace registry to register our target.
        aServiceDependencyList.add(INamespaceRegistry.class);
        // The command line interface is used to allow the user to add pings.
        aServiceDependencyList.add(ICommandLineInterface.class);
    }

    @Override
    public void start(@NotNull final IServiceRegistry aServiceRegistry) throws Exception
    {
        // The dependencies are fulfilled, so we start the package by creating our service
        if (mService == null)
        {
            mNamespaceRegistry = aServiceRegistry.getService(INamespaceRegistry.class);

            mService = new CServiceExample001(this);
            mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull final IServiceRegistry aServiceRegistry) throws Exception
    {
        // The dependencies are no longer all fulfilled, so we stop the service
        if (mService != null)
        {
            mService.deactivate(aServiceRegistry);
            mService = null;
        }
    }

    @Override
    public @NotNull INamespaceRegistry getNamespaceRegistry()
    {
        return mNamespaceRegistry;
    }
}
