/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.stream.hook;

import de.sillysky.nyssr.impl.network.stream.hook.CMonitorFilterInputStream;
import de.sillysky.nyssr.impl.network.stream.hook.CMonitorFilterOutputStream;
import de.sillysky.nyssr.network.stream.hook.IStreamHook;
import de.sillysky.nyssr.network.stream.hook.IStreamMonitor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

final class CStreamHook
implements IStreamHook {
    private final Set<IStreamMonitor> mMonitor = new CopyOnWriteArraySet<IStreamMonitor>();
    private InputStream mInputStream;
    private OutputStream mOutputStream;

    CStreamHook() {
    }

    public void addMonitor(IStreamMonitor aMonitor) {
        this.mMonitor.add(aMonitor);
    }

    public InputStream createInputStream(InputStream aStream) {
        if (this.mInputStream == null) {
            this.mInputStream = new CMonitorFilterInputStream(aStream, this.mMonitor);
        }
        return this.mInputStream;
    }

    public OutputStream createOutputStream(OutputStream aStream) {
        if (this.mOutputStream == null) {
            this.mOutputStream = new CMonitorFilterOutputStream(aStream, this.mMonitor);
        }
        return this.mOutputStream;
    }

    public void dismiss() {
    }

    public void removeMonitor(IStreamMonitor aMonitor) {
        this.mMonitor.remove(aMonitor);
    }
}

