/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.software.updater.local.CSerialJobMachine;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.job.serial.ISerialJobQueueEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CJobCopyOldFiles
implements ISerialJobQueueEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJobCopyOldFiles.class);
    private final CSerialJobMachine mParent;
    private final Path mSourcePath;
    private final Path mDestinationPath;

    CJobCopyOldFiles(@NotNull CSerialJobMachine aParent, @NotNull Path aSourcePath, @NotNull Path aDestinationPath) {
        this.mParent = aParent;
        this.mSourcePath = aSourcePath;
        this.mDestinationPath = aDestinationPath;
    }

    @NotNull
    public String getId() {
        return "CopyOldFiles(" + String.valueOf(this.mDestinationPath) + ")";
    }

    public void stop() {
    }

    public void start() throws Exception {
        boolean hasRight = this.mParent.checkRight("NY_SoftwareUpdate");
        if (!hasRight) {
            LOG.error("Insufficient rights to perform software update");
            this.mParent.finish(5105, "Insufficient rights to perform software update");
            return;
        }
        this.copyFiles(this.mSourcePath, this.mDestinationPath);
        this.mParent.jobFinished(this);
    }

    private void copyFiles(@NotNull Path aSourcePath, @NotNull Path aDestinationPath) throws CException {
        CUtilFile.throwIfFileDoesntExist((File)aSourcePath.toFile());
        this.createOrClearDirectory(aDestinationPath);
        try {
            Stream<Path> list = Files.list(aSourcePath);
            list.forEach(sourceFile -> {
                try {
                    Path targetFile = aDestinationPath.resolve(sourceFile.getFileName());
                    Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOG.error("Error copying the file: {}", new Object[]{sourceFile.getFileName()});
                }
            });
            LOG.debug("All files have been copied to the target directory.");
        }
        catch (IOException aException) {
            throw new CException((Throwable)aException);
        }
    }

    private void createOrClearDirectory(@NotNull Path aDir) throws CException {
        File dir = aDir.toFile();
        if (dir.exists()) {
            CUtilFile.removeAllFilesInDirectory((File)dir);
        } else {
            CUtilFile.createDirectoriesEx((File)dir);
        }
    }
}

