/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EHorizontalJustification;
import de.sillysky.nyssr.remoteskin.model.enums.EVerticalJustification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.CJsonBorderUtil;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import de.sillysky.nyssr.util.CUtilEnum;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTitledBorder
implements IBorder,
IRemoteSkinEvent {
    private static final String BORDER_TYPE = "border_type";
    private static final String TITLE = "title";
    private static final String BORDER = "border";
    private static final String JUSTIFICATION = "justification";
    private static final String POSITION = "position";
    private static final String FONT = "font";
    private static final String COLOR = "color";
    private final IBorder mBorder;
    private final String mTitle;
    private final EHorizontalJustification mJustification;
    private final EVerticalJustification mPosition;
    private final Font mFont;
    private final Color mColor;

    public CEventTitledBorder(String aTitle, IBorder aBorder, EHorizontalJustification aJustification, EVerticalJustification aPosition, Font aFont, Color aColor) {
        this.mTitle = aTitle;
        this.mBorder = aBorder;
        this.mJustification = aJustification;
        this.mPosition = aPosition;
        this.mFont = aFont;
        this.mColor = aColor;
    }

    @Nullable
    public static CEventTitledBorder create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            String title = CUtilJsonString.fromJson((CJsonObject)jo, (String)TITLE, (String)"?");
            Object value = jo.getValue(BORDER);
            IBorder border = CJsonBorderUtil.create(value);
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)JUSTIFICATION, null);
            EHorizontalJustification justification = (EHorizontalJustification)((Object)CUtilEnum.fromString(EHorizontalJustification.class, (String)s, (Object)((Object)EHorizontalJustification.default_Justification)));
            s = CUtilJsonString.fromJson((CJsonObject)jo, (String)POSITION, null);
            EVerticalJustification position = (EVerticalJustification)((Object)CUtilEnum.fromString(EVerticalJustification.class, (String)s, (Object)((Object)EVerticalJustification.default_justification)));
            Object o = jo.getValue(FONT);
            CEventFont data = CEventFont.create(o);
            Font font = data == null ? null : data.createFont();
            o = jo.getValue(COLOR);
            CEventColor c = CEventColor.create(o);
            Color color = c == null ? null : c.createColor();
            return new CEventTitledBorder(title, border, justification, position, font, color);
        }
        return null;
    }

    public IBorder getBorder() {
        return this.mBorder;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public EHorizontalJustification getJustification() {
        return this.mJustification;
    }

    public EVerticalJustification getPosition() {
        return this.mPosition;
    }

    public Font getFont() {
        return this.mFont;
    }

    public Color getColor() {
        return this.mColor;
    }

    @Override
    public Border createBorder() {
        if (this.mBorder != null) {
            int justification = this.getSwingHorizontalJustification(this.mJustification);
            int position = this.getSwingVerticalJustification(this.mPosition);
            if (this.mFont != null && this.mColor != null) {
                return BorderFactory.createTitledBorder(this.mBorder.createBorder(), this.mTitle, justification, position, this.mFont, this.mColor);
            }
            return BorderFactory.createTitledBorder(this.mBorder.createBorder(), this.mTitle, justification, position);
        }
        return BorderFactory.createTitledBorder(this.mTitle);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(BORDER_TYPE, (Object)this.getType().name());
        jo.put(TITLE, (Object)this.mTitle);
        if (this.mBorder != null) {
            jo.put(BORDER, this.mBorder.toJson());
        }
        jo.put(JUSTIFICATION, (Object)this.mJustification.name());
        jo.put(POSITION, (Object)this.mPosition.name());
        if (this.mFont != null) {
            CEventFont df = new CEventFont(this.mFont);
            jo.put(FONT, df.toJson());
        }
        if (this.mColor != null) {
            CEventColor dc = new CEventColor(this.mColor);
            jo.put(COLOR, dc.toJson());
        }
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.titled;
    }

    int getSwingHorizontalJustification(@NotNull EHorizontalJustification aJustification) {
        switch (aJustification) {
            case center: {
                return 2;
            }
            case right: {
                return 3;
            }
            case leading: {
                return 4;
            }
            case trailing: {
                return 5;
            }
            case left: {
                return 1;
            }
        }
        return 0;
    }

    int getSwingVerticalJustification(@NotNull EVerticalJustification aJustification) {
        switch (aJustification) {
            case above_top: {
                return 1;
            }
            case top: {
                return 2;
            }
            case below_top: {
                return 3;
            }
            case above_bottom: {
                return 4;
            }
            case bottom: {
                return 5;
            }
            case below_bottom: {
                return 6;
            }
        }
        return 0;
    }
}

