/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.layout;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventCardLayout
implements IRemoteSkinEvent {
    private static final String HGAP = "hgap";
    private static final String VGAP = "vgap";
    private static final int DEFAULT_GAP = 0;
    private final int mHorizontalGap;
    private final int mVerticalGap;

    public CEventCardLayout() {
        this.mHorizontalGap = 0;
        this.mVerticalGap = 0;
    }

    public CEventCardLayout(int aHorizontalGap, int aVerticalGap) {
        this.mHorizontalGap = aHorizontalGap;
        this.mVerticalGap = aVerticalGap;
    }

    public static CEventCardLayout create(@Nullable Object aValue) {
        boolean enabled;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int hGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)HGAP, (int)0);
            int vGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)VGAP, (int)0);
            return new CEventCardLayout(hGap, vGap);
        }
        if (aValue instanceof Boolean && (enabled = ((Boolean)aValue).booleanValue())) {
            return new CEventCardLayout();
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mHorizontalGap != 0) {
            jo.put(HGAP, (Object)this.mHorizontalGap);
        }
        if (this.mVerticalGap != 0) {
            jo.put(VGAP, (Object)this.mVerticalGap);
        }
        return jo;
    }

    public int getHorizontalGap() {
        return this.mHorizontalGap;
    }

    public int getVerticalGap() {
        return this.mVerticalGap;
    }
}

