/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.link.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class CLink {
    private final CNodeAddress mNode1;
    private final CNodeAddress mNode2;
    private int mCosts;

    CLink(@NotNull CNodeAddress aNode1, @NotNull CNodeAddress aNode2, int aCosts) {
        if (aNode1.compareTo(aNode2) > 0) {
            this.mNode1 = aNode1;
            this.mNode2 = aNode2;
        } else {
            this.mNode1 = aNode2;
            this.mNode2 = aNode1;
        }
        this.mCosts = aCosts;
    }

    CLink(@NotNull CNodeAddress aNode1, @NotNull CNodeAddress aNode2) {
        this(aNode1, aNode2, 1);
    }

    CNodeAddress getNode1() {
        return this.mNode1;
    }

    CNodeAddress getNode2() {
        return this.mNode2;
    }

    int getCosts() {
        return this.mCosts;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CLink cLink = (CLink)aOther;
        return this.mNode1.equals((Object)cLink.mNode1) && this.mNode2.equals((Object)cLink.mNode2);
    }

    public int hashCode() {
        return Objects.hash(this.mNode1, this.mNode2);
    }

    public String toString() {
        return "{" + String.valueOf(this.mNode1) + " <-- " + this.mCosts + " --> " + String.valueOf(this.mNode2) + "}";
    }

    public boolean hasNode(@NotNull CNodeAddress aNode) {
        return this.mNode1.equals((Object)aNode) || this.mNode2.equals((Object)aNode);
    }

    public void updateCosts(int aCosts) {
        this.mCosts = aCosts;
    }
}

