/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.converter.ui;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.kernel.config.file.reader.CPackageImplKernelConfigFileReader;
import de.sillysky.nyssr.impl.properties.string.CPackageImplPropertiesString;
import de.sillysky.nyssr.impl.record.converter.ui.CPackageRecordConverterUi;
import de.sillysky.nyssr.impl.record.converter.ui.CUiConstants;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.configuration.ETypeOfNode;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CDefaultConsoleLogWriter;
import de.sillysky.nyssr.log.CDefaultMessageFormatter;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ELevel;
import de.sillysky.nyssr.log.ILogConfiguration;
import de.sillysky.nyssr.log.ILogWriter;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.log.IMessageFormatter;
import de.sillysky.nyssr.module.CModuleId;
import de.sillysky.nyssr.module.CModuleJson;
import de.sillysky.nyssr.module.CModuleKernelConfiguration;
import de.sillysky.nyssr.module.CModuleMessage;
import de.sillysky.nyssr.module.CModuleNameDb;
import de.sillysky.nyssr.module.CModuleRecordDb;
import de.sillysky.nyssr.module.CModuleRecordParserJson;
import de.sillysky.nyssr.module.CModuleRecordParserXml;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordDatabaseFactory;
import de.sillysky.nyssr.record.parser.json.IRecordParserJson;
import de.sillysky.nyssr.record.parser.xml.IRecordParserXml;
import de.sillysky.nyssr.record.writer.json.IRecordWriterJson;
import de.sillysky.nyssr.record.writer.xml.IRecordWriterXml;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public final class CRecordConverter
extends JFrame
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordConverter.class);
    private static final String EXT_XML = "xml";
    private static final String EXT_JSON = "json";
    private String mLastFile;
    private String mSourcePrefix = "src/main/java";
    private JLabel mLabelFile;
    private JButton mButtonStart;

    CRecordConverter() {
        super("Record Converter");
    }

    public static void main(String[] aArgs) {
        ILogConfiguration configuration = CLoggerFactory.getConfiguration();
        CDefaultConsoleLogWriter writer = new CDefaultConsoleLogWriter();
        writer.setMessageFormatter((IMessageFormatter)new CDefaultMessageFormatter());
        writer.setLevel(ELevel.DEBUG);
        configuration.addWriter((ILogWriter)writer);
        LOG.info("Start RecordConverter");
        CServiceRegistry sr = CServiceRegistry.getInstance();
        sr.addStarter((IServiceStarter)new CPackageImplPropertiesString());
        sr.addStarter((IServiceStarter)new CPackageImplKernelConfigFileReader());
        sr.addStarter((IServiceStarter)new CPackageRecordConverterUi());
        CStringProperties properties = new CStringProperties();
        properties.put("type.of.node", ETypeOfNode.TOOL.name());
        for (String a : aArgs) {
            if (a.indexOf(61) <= 0) continue;
            String[] strings = a.split("=");
            String key = strings[0].trim();
            String value = strings[1].trim();
            properties.put(key, value);
        }
        CModuleKernelConfiguration.initialize((IServiceRegistry)sr, (CStringProperties)properties);
        CModuleId.initialize((IServiceRegistry)sr);
        CModuleNameDb.initialize((CServiceRegistry)sr);
        CModuleMessage.initialize((IServiceRegistry)sr);
        CModuleRecordDb.initialize((IServiceRegistry)sr);
        CModuleJson.initialize((CServiceRegistry)sr);
        CModuleRecordParserJson.initialize((IServiceRegistry)sr);
        CModuleRecordParserXml.initialize((IServiceRegistry)sr);
        sr.printStatus();
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(IRecordDatabaseFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IRecordDatabaseFactory recordDatabaseFactory = (IRecordDatabaseFactory)aServiceRegistry.getService(IRecordDatabaseFactory.class);
        CUtilCheck.checkNotNull((Object)recordDatabaseFactory, (String)"Missing Record Database Factory", (Object[])new Object[0]);
        LOG.debug("Activate {}", new Object[]{this.getClass().getSimpleName()});
        LOG.info("Record Converter started.");
        SwingUtilities.invokeLater(() -> {
            this.init();
            this.getPreferences();
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        });
    }

    private Component addComponents(Container aParent) {
        JPanel p = new JPanel();
        p.setBackground(CUiConstants.BACKGROUND_PANEL);
        p.setLayout((LayoutManager)new MigLayout(""));
        JButton buttonChoose = new JButton("Choose File");
        buttonChoose.setMnemonic(67);
        buttonChoose.addActionListener(e -> this.chooseFile());
        p.add((Component)buttonChoose, "");
        this.mLabelFile = new JLabel("");
        p.add((Component)this.mLabelFile, "wrap, width 1000px");
        this.mButtonStart = new JButton("Start Conversion");
        this.mButtonStart.setMnemonic(83);
        this.mButtonStart.addActionListener(e -> this.convertFile());
        this.mButtonStart.setEnabled(false);
        p.add((Component)this.mButtonStart, "wrap");
        aParent.add(p);
        return p;
    }

    private void chooseFile() {
        JFileChooser chooser = new JFileChooser();
        if (this.mLastFile != null && !this.mLastFile.isEmpty()) {
            chooser.setCurrentDirectory(new File(this.mLastFile));
        }
        chooser.setDialogTitle("Search File to convert");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter ff1 = new FileNameExtensionFilter("xml file", EXT_XML);
        FileNameExtensionFilter ff2 = new FileNameExtensionFilter("json file", EXT_JSON);
        chooser.setFileFilter(ff1);
        chooser.addChoosableFileFilter(ff1);
        chooser.addChoosableFileFilter(ff2);
        if (chooser.showOpenDialog(this) == 0) {
            File selectedFile = chooser.getSelectedFile().getAbsoluteFile();
            String path1 = selectedFile.toString();
            this.setLastScanDir(path1, true);
        }
    }

    private void convertFile() {
        if (CUtilString.isValid((String)this.mLastFile)) {
            String dir = this.mLastFile.toLowerCase();
            if (dir.endsWith(EXT_XML)) {
                this.convertXml();
            }
            if (dir.endsWith(EXT_JSON)) {
                this.convertJson();
            }
        }
    }

    private void convertJson() {
        try {
            CServiceRegistry sr = CServiceRegistry.getInstance();
            IRecordParserJson parserJson = (IRecordParserJson)sr.getService(IRecordParserJson.class);
            if (parserJson == null) {
                LOG.error("No Json Parser available");
                return;
            }
            IRecordWriterXml writerXml = (IRecordWriterXml)sr.getService(IRecordWriterXml.class);
            if (writerXml == null) {
                LOG.error("No XML Writer available");
                return;
            }
            IRecordDatabaseFactory fac = (IRecordDatabaseFactory)sr.getService(IRecordDatabaseFactory.class);
            if (fac == null) {
                LOG.error("No RecordDatabase available");
                return;
            }
            IRecordDatabase database = fac.createRecordDatabase();
            parserJson.parseFile(database, new File(this.mLastFile).toPath());
            Collection list = database.getRecordIdStrings();
            String dir = this.mLastFile.substring(0, this.mLastFile.length() - EXT_JSON.length()) + EXT_XML;
            Path path = Paths.get(dir, new String[0]);
            writerXml.writeXml(database, path, list);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error converting the file {}", new Object[]{this.mLastFile});
        }
    }

    private void convertXml() {
        try {
            CServiceRegistry sr = CServiceRegistry.getInstance();
            IRecordParserXml parserXml = (IRecordParserXml)sr.getService(IRecordParserXml.class);
            if (parserXml == null) {
                LOG.error("No XML Parser available");
                return;
            }
            IRecordWriterJson writerJson = (IRecordWriterJson)sr.getService(IRecordWriterJson.class);
            if (writerJson == null) {
                LOG.error("No JSON Writer available");
                return;
            }
            IRecordDatabaseFactory fac = (IRecordDatabaseFactory)sr.getService(IRecordDatabaseFactory.class);
            if (fac == null) {
                LOG.error("No RecordDatabase available");
                return;
            }
            IRecordDatabase database = fac.createRecordDatabase();
            parserXml.parseFile(database, new File(this.mLastFile).toPath());
            Collection list = database.getRecordIdStrings();
            String dir = this.mLastFile.substring(0, this.mLastFile.length() - EXT_XML.length()) + EXT_JSON;
            Path path = Paths.get(dir, new String[0]);
            writerJson.writeJson(database, path, list);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error converting the file {}", new Object[]{this.mLastFile});
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        LOG.debug("Deactivate {}", new Object[]{this.getClass().getSimpleName()});
        SwingUtilities.invokeLater(() -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    private void getPreferences() {
        Preferences systemRoot = Preferences.userRoot();
        Preferences generatorNode = systemRoot.node("D1RecordConverter");
        String dir = generatorNode.get("LastScanDirectory", "");
        this.setLastScanDir(dir, false);
        this.mSourcePrefix = generatorNode.get("sourcePrefix", "");
        LOG.info("Source Prefix is {}", new Object[]{this.mSourcePrefix});
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(this){});
        this.setDefaultCloseOperation(3);
        try {
            InputStream stream = CRecordConverter.class.getResourceAsStream("/images/softdevel.gif");
            if (stream != null) {
                BufferedImage image = ImageIO.read(stream);
                this.setIconImage(image);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Can't load image icon");
        }
        Container pane = this.getContentPane();
        this.getRootPane().setBackground(CUiConstants.BACKGROUND_FRAME);
        this.getRootPane().setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addComponents(pane);
    }

    private void save() {
        Preferences systemRoot = Preferences.userRoot();
        Preferences generatorNode = systemRoot.node("D1RecordConverter");
        generatorNode.put("LastScanDirectory", this.mLastFile);
        generatorNode.put("sourcePrefix", this.mSourcePrefix);
        try {
            systemRoot.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void setLastScanDir(String aDir, boolean aSave) {
        this.mLastFile = aDir;
        LOG.info("Scan Directory is {}", new Object[]{this.mLastFile});
        this.mButtonStart.setEnabled(CUtilString.isValid((String)this.mLastFile));
        this.mLabelFile.setText(this.mLastFile);
        if (aSave) {
            this.save();
        }
    }
}

