/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.connection;

import de.sillysky.nyssr.impl.shutdown.IShutDownHandler;
import de.sillysky.nyssr.impl.tcp.connection.CTcpConnectionFactory;
import de.sillysky.nyssr.impl.tcp.connection.IDependencies;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.network.stream.hook.IStreamHookFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackageTcpConnection
implements IServiceStarter,
IDependencies {
    private IService mService;
    private INameDb mNameDb;
    private INamespaceFactory mNamespaceFactory;
    private IStreamHookFactory mStreamHookFactory;

    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INameDb.class);
        aDependencyList.add(IStreamHookFactory.class);
        aDependencyList.add(INamespaceFactory.class);
        aDependencyList.add(IShutDownHandler.class);
    }

    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
            this.mStreamHookFactory = (IStreamHookFactory)aServiceRegistry.getService(IStreamHookFactory.class);
            this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getService(INamespaceFactory.class);
            this.mService = new CTcpConnectionFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INameDb getNameDb() {
        return this.mNameDb;
    }

    @Override
    @NotNull
    public INamespaceFactory getNamespaceFactory() {
        return this.mNamespaceFactory;
    }

    @Override
    @NotNull
    public IStreamHookFactory getStreamHookFactory() {
        return this.mStreamHookFactory;
    }
}

