/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.connection;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.shutdown.records.CRecordNotifyShutdown;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdownAddListener;
import de.sillysky.nyssr.impl.tcp.connection.IDependencies;
import de.sillysky.nyssr.kernel.records.CRecordDismiss;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.network.connection.records.CRecordDataConnection;
import de.sillysky.nyssr.network.connection.records.EConnectionType;
import de.sillysky.nyssr.network.records.CRecordNetworkDataForRemote;
import de.sillysky.nyssr.network.records.CRecordNetworkDataFromRemote;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionClosed;
import de.sillysky.nyssr.network.records.CRecordNetworkNotifyConnectionOpened;
import de.sillysky.nyssr.network.stream.hook.IStreamHook;
import de.sillysky.nyssr.network.transport.records.CRecordConnectionRead;
import de.sillysky.nyssr.network.transport.records.CRecordConnectionStartReceiving;
import de.sillysky.nyssr.network.transport.records.CRecordConnectionStopReceiving;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.tcp.ITcpConnection;
import de.sillysky.nyssr.tcp.ITcpConnectionOwner;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class CTcpConnection
extends CTarget
implements ITcpConnection,
Runnable {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTcpConnection.class);
    private static final int SLEEP_TIME = 100;
    private final AtomicBoolean mPaused = new AtomicBoolean(true);
    private final AtomicBoolean mRunning = new AtomicBoolean();
    private final AtomicBoolean mStop = new AtomicBoolean();
    private UUID mId;
    private boolean mIsIncomingConnection;
    private ITcpConnectionOwner mOwner;
    private Socket mSocket;
    private Thread mThread;
    private InputStream mFilterIn;
    private OutputStream mFilterOut;
    private byte[] mBuffer;
    private String mRemoteAddress;
    private String mLocalAddress;
    private IStreamHook mStreamHook;
    private final IDependencies mDependencies;
    private static final EConnectionType TYPE = EConnectionType.TCP;
    private CTargetAddress mDataReceiver = null;
    private UUID mTransactionId;
    private int mBytesToRead = 0;

    public CTcpConnection(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    void activate(@NotNull INamespace aNamespace, IStreamHook aStreamHook) throws CException {
        LOG.debug("Activate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.mStreamHook = aStreamHook;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkDataForRemote.ID, this::asyncDataForRemote);
        this.addMessageHandler(CRecordConnectionStartReceiving.ID, this::asyncStartReceiving);
        this.addMessageHandler(CRecordConnectionStopReceiving.ID, this::asyncStopReceiving);
        this.addMessageHandler(CRecordDismiss.ID, this::asyncDismiss);
        this.addMessageHandler(CRecordNotifyShutdown.ID, this::asyncNotifyShutDown);
        this.addMessageHandler(CRecordConnectionRead.ID, this::asyncRead);
        this.addMessageHandler(CRecordNetworkDataFromRemote.ID, this::asyncNetworkDataFromRemote);
        aNamespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    void deactivate() {
        LOG.debug("Deactivate {} {}", new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        this.close();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(this.getAddress(), "TCP-Connection");
        this.sendAddShutDownListener();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartReceiving(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.debug("Got start receiving.");
        this.mDataReceiver = aEnvelope.getSender();
        this.resume();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRead(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        int length = CRecordConnectionRead.getLength((CRecord)aRecord, (int)0);
        CUtilCheck.checkTrue((length > 0 ? 1 : 0) != 0, (String)("Length too small: " + length), (Object[])new Object[0]);
        LOG.debug("Shall read {} bytes.", new Object[]{length});
        this.mBytesToRead = length;
        this.mDataReceiver = aEnvelope.getSender();
        this.resume();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNetworkDataFromRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            UUID connectionId = CRecordNetworkDataFromRemote.getConnectionId((CRecord)aRecord, null);
            if (connectionId != null) {
                this.mId = connectionId;
            }
            return true;
        }
        return false;
    }

    private boolean asyncStopReceiving(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.debug("Got stop receiving.");
        this.pause();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDataForRemote(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] bb = CRecordNetworkDataForRemote.getData((CRecord)aRecord, null);
        if (bb == null || bb.length == 0) {
            String txt = "Can't send 0 bytes.";
            LOG.error("Can't send 0 bytes.");
            aEnvelope.setResult(7, "Can't send 0 bytes.");
            return true;
        }
        try {
            LOG.trace("TX " + bb.length);
            this.send(bb);
            aEnvelope.setResultSuccess();
        }
        catch (Exception e) {
            InetAddress inetAddress = this.getInetAddress();
            int port = this.getRemotePort();
            LOG.error("Can't write to socket {}:{}: {}", new Object[]{inetAddress, port, e.getMessage()});
            aEnvelope.setResult(5201, "Socket Closed");
            this.close();
        }
        return true;
    }

    protected boolean asyncDismiss(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.debug("Got dismiss.");
        this.close();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyShutDown(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.debug("Got shutdown.");
        this.close();
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void close() {
        this.mStop.set(true);
        if (!this.mSocket.isClosed()) {
            InetAddress inetAddress = this.mSocket.getInetAddress();
            int port = this.mSocket.getPort();
            LOG.debug("Close connection socket for {}:{}.", new Object[]{inetAddress, port});
            try {
                this.mSocket.close();
                LOG.info("Connection socket for {}:{} closed.", new Object[]{inetAddress, port});
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "Error on closing Connection socket for {}:{}.", new Object[]{inetAddress, port});
            }
            try {
                this.mOwner.deleteMe(this);
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Error on deleting TcpConnection");
            }
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this.mSocket.getInetAddress();
    }

    @Override
    public UUID getID() {
        return this.mId;
    }

    @Override
    public int getLocalPort() {
        return this.mSocket.getLocalPort();
    }

    @Override
    public String getLocalTcpAddress() {
        return this.mLocalAddress;
    }

    private OutputStream getOutputStream() {
        return this.mFilterOut;
    }

    @Override
    public int getRemotePort() {
        return this.mSocket.getPort();
    }

    @Override
    public String getRemoteTcpAddress() {
        return this.mRemoteAddress;
    }

    void initialize(@NotNull ITcpConnectionOwner aOwner, Socket aClientSocket, int aBufSize, boolean aIsIncomingConnection) throws IOException {
        this.mOwner = aOwner;
        this.mSocket = aClientSocket;
        this.mIsIncomingConnection = aIsIncomingConnection;
        if (!aIsIncomingConnection) {
            UUID id = aOwner.getConnectionID();
            this.mId = CUtilUuid.isValid((UUID)id) ? id : UUID.randomUUID();
        }
        this.mBuffer = new byte[aBufSize];
        this.mRemoteAddress = this.mSocket.getInetAddress().toString() + ":" + this.mSocket.getPort();
        this.mLocalAddress = this.mSocket.getLocalAddress().toString() + ":" + this.mSocket.getLocalPort();
        InputStream is = this.mSocket.getInputStream();
        BufferedInputStream inputStream = new BufferedInputStream(is);
        this.mFilterIn = this.mStreamHook != null ? this.mStreamHook.createInputStream((InputStream)inputStream) : inputStream;
        OutputStream os = this.mSocket.getOutputStream();
        BufferedOutputStream outputStream = new BufferedOutputStream(os);
        this.mFilterOut = this.mStreamHook != null ? this.mStreamHook.createOutputStream((OutputStream)outputStream) : outputStream;
        this.mStop.set(false);
        this.mThread = new Thread((Runnable)this, "TcpConnection-Port-" + this.mSocket.getLocalPort());
        this.mThread.start();
    }

    private boolean isClosed() {
        return this.mSocket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.mSocket.isConnected();
    }

    @Override
    public boolean isIncomingConnection() {
        return this.mIsIncomingConnection;
    }

    @Override
    public void pause() {
        LOG.debug("Pause.");
        this.mPaused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        LOG.debug("Resume.");
        this.mPaused.set(false);
        AtomicBoolean atomicBoolean = this.mPaused;
        synchronized (atomicBoolean) {
            this.mPaused.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.debug("TcpConnection started: {}", new Object[]{this.toString()});
        this.mRunning.set(true);
        this.sendNotifyConnectionOpened();
        while (!this.mStop.get()) {
            if (this.mPaused.get()) {
                AtomicBoolean atomicBoolean = this.mPaused;
                synchronized (atomicBoolean) {
                    while (this.mPaused.get()) {
                        try {
                            this.mPaused.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            try {
                if (this.mBytesToRead > 0) {
                    byte[] bytes = new byte[this.mBytesToRead];
                    this.mBytesToRead = 0;
                    DataInputStream dis = new DataInputStream(this.mFilterIn);
                    dis.readFully(bytes);
                    this.sendDataFromRemote(bytes);
                    this.mPaused.set(true);
                    continue;
                }
                int bytesRead = this.mFilterIn.read(this.mBuffer);
                if (bytesRead <= 0) continue;
                byte[] data = new byte[bytesRead];
                System.arraycopy(this.mBuffer, 0, data, 0, bytesRead);
                this.sendDataFromRemote(data);
            }
            catch (SocketException e) {
                LOG.debug("Socket closed {} {}", new Object[]{this.toString(), e.getMessage()});
                this.mStop.set(true);
            }
            catch (Exception e) {
                LOG.error("Exception reading from Tcp: {} {}", new Object[]{this.toString(), e.getMessage()});
                this.mStop.set(true);
            }
        }
        this.mRunning.set(false);
        LOG.debug("TcpConnection stopped: {}", new Object[]{this.toString()});
        this.mThread = null;
        this.notifyClosed();
    }

    @Override
    public void send(byte[] aData) throws Exception {
        if (this.isClosed()) {
            throw new CException(5201).append("Socket closed.");
        }
        OutputStream os = this.getOutputStream();
        os.write(aData);
        os.flush();
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder().append("TcpConnection ");
        if (this.mId != null) {
            sb.append(' ').append(this.mId.toString());
        }
        sb.append(' ').append(this.mLocalAddress).append("<-->").append(this.mRemoteAddress);
        return sb.toString();
    }

    @NotNull
    private CRecord createRecord(@NotNull CTargetAddress aAdr) throws CException {
        CRecord rec = CRecordDataConnection.create();
        CRecordDataConnection.setConnectionId((CRecord)rec, (UUID)this.getID());
        CRecordDataConnection.setTargetAddress((CRecord)rec, (CTargetAddress)aAdr);
        CRecordDataConnection.setLocalAddress((CRecord)rec, (String)this.getLocalTcpAddress());
        CRecordDataConnection.setRemoteAddress((CRecord)rec, (String)this.getRemoteTcpAddress());
        CRecordDataConnection.setConnectionType((CRecord)rec, (String)TYPE.toString());
        CRecordDataConnection.setIncoming((CRecord)rec, (boolean)this.isIncomingConnection());
        return rec;
    }

    void notifyClosed() {
        CTargetAddress adr = this.getAddress();
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkNotifyConnectionClosed.class);
            env.setTransactionId(this.mTransactionId);
            CRecord innerRec = this.createRecord(adr);
            CRecord outerRec = CRecordNetworkNotifyConnectionClosed.create();
            CRecordNetworkNotifyConnectionClosed.setConnection((CRecord)outerRec, (CRecord)innerRec);
            this.sendNotification(env, outerRec);
            this.mTransactionId = null;
        }
        catch (CException e) {
            LOG.warn("Error sending {}: {}", new Object[]{CRecordNetworkNotifyConnectionClosed.class.getSimpleName(), e.getCombinedText()});
        }
    }

    void sendNotifyConnectionOpened() {
        CTargetAddress adr = this.getAddress();
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CRecordNetworkNotifyConnectionOpened.class);
            env.setTransactionId(this.mTransactionId);
            CRecord rec1 = CRecordNetworkNotifyConnectionOpened.create();
            CRecord rec2 = this.createRecord(adr);
            CRecordNetworkNotifyConnectionOpened.setConnection((CRecord)rec1, (CRecord)rec2);
            this.sendNotification(env, rec1);
            this.mTransactionId = null;
        }
        catch (CException e) {
            LOG.error("Error sending {}: {}", new Object[]{CRecordNetworkNotifyConnectionOpened.class.getSimpleName(), e.getCombinedText()});
        }
    }

    void sendDataFromRemote(byte @NotNull [] aData) throws CException {
        LOG.trace("RX " + aData.length + " for " + String.valueOf(this.mDataReceiver));
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mDataReceiver);
        env.setLogEnabled(false);
        CRecord rec = CRecordNetworkDataFromRemote.create();
        CRecordNetworkDataFromRemote.setData((CRecord)rec, (byte[])aData);
        this.sendRequest(env, rec);
    }

    private void sendAddShutDownListener() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordShutdownAddListener.create();
        this.sendNotification(env, record);
    }
}

