/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.session.verifier;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.session.verifier.CSessionData;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.string.CUtilBase64;
import de.sillysky.nyssr.util.time.CUtilZonedDateTime;
import de.sillysky.nyssr.util.zip.CUtilZip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilSession {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilSession.class);

    private CUtilSession() {
    }

    private static byte[] signData(byte[] aData, @NotNull PrivateKey aPrivateKey) throws Exception {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(aPrivateKey);
        signature.update(aData);
        return signature.sign();
    }

    private static boolean verifySignature(byte @NotNull [] aCombined, @NotNull PublicKey aPublicKey) {
        byte[] receivedData = CUtilSession.getDataInternal(aCombined);
        byte[] receivedSignature = CUtilSession.getSignatureInternal(aCombined);
        return CUtilSession.verifySignatureInternal(receivedData, receivedSignature, aPublicKey);
    }

    private static boolean verifySignatureInternal(byte @NotNull [] aData, byte @NotNull [] aSignatureData, @NotNull PublicKey aPublicKey) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(aPublicKey);
            signature.update(aData);
            return signature.verify(aSignatureData);
        }
        catch (Exception aException) {
            LOG.error("Failed to verify signature", aException);
            return false;
        }
    }

    private static byte @NotNull [] getDataInternal(byte @NotNull [] aCombinedData) {
        int dataLength = aCombinedData.length - 256;
        byte[] data = new byte[dataLength];
        System.arraycopy(aCombinedData, 0, data, 0, dataLength);
        return data;
    }

    private static byte @NotNull [] getSignatureInternal(byte @NotNull [] aCombinedData) {
        int dataPos = aCombinedData.length - 256;
        byte[] signature = new byte[256];
        System.arraycopy(aCombinedData, dataPos, signature, 0, 256);
        return signature;
    }

    @Nullable
    private static CSessionData deserializeDataInternal(byte @NotNull [] aData) {
        try {
            byte[] decompress = CUtilZip.unpackZip(aData, LOG);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(decompress);
            DataInputStream dataStream = new DataInputStream(byteStream);
            byte[] shortToken = CUtilByteArray.fromStream(dataStream);
            String userId = dataStream.readUTF();
            @NotNull String[] permissions = CUtilStringArray.fromStream(dataStream);
            ZonedDateTime dateTime = CUtilZonedDateTime.fromStream(dataStream);
            if (dateTime == null) {
                dateTime = ZonedDateTime.now();
            }
            return new CSessionData(shortToken, userId, permissions, dateTime);
        }
        catch (Exception aE) {
            LOG.error(aE.getMessage(), aE);
            return null;
        }
    }

    @Nullable
    public static CSessionData verifyAndDeserializeData(byte @NotNull [] aCombined, @NotNull PublicKey aPublicKey) {
        byte[] signature;
        byte[] data = CUtilSession.getDataInternal(aCombined);
        boolean valid = CUtilSession.verifySignatureInternal(data, signature = CUtilSession.getSignatureInternal(aCombined), aPublicKey);
        if (!valid) {
            return null;
        }
        return CUtilSession.deserializeDataInternal(data);
    }

    private static byte @NotNull [] serializeData(byte[] aShortToken, @NotNull String aUserId, @NotNull String[] aRightIds, @NotNull ZonedDateTime aDateTime) throws IOException, CException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        CUtilByteArray.toStream(dataStream, aShortToken);
        dataStream.writeUTF(aUserId);
        CUtilStringArray.toStream(dataStream, aRightIds);
        CUtilZonedDateTime.toStream(dataStream, aDateTime);
        byte[] bytes = byteStream.toByteArray();
        return CUtilZip.packEx(bytes, LOG);
    }

    public static KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte @NotNull [] encodeSession(@NotNull PrivateKey aPrivateKey, @NotNull CSessionData aData) throws Exception {
        byte[] data = CUtilSession.serializeData(aData.getShortToken(), aData.getUserId(), aData.getRightIds(), aData.getTimeStamp());
        byte[] signature = CUtilSession.signData(data, aPrivateKey);
        return ByteBuffer.allocate(data.length + signature.length).put(data).put(signature).array();
    }

    public static void main(@NotNull String[] aArgs) throws Exception {
        KeyPair keyPair = CUtilSession.generateRSAKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        UUID token = CUtilUuid.random();
        byte[] uuidData = CUtilUuid.toByteArray(token);
        System.out.println("Token length: " + uuidData.length + " bytes");
        String[] values = new String[]{"NY_CreateUser", "NY_DeleteUser", "NY_VerifyUser", "NY_ChangePassword", "NY_UpdateUser", "NY_GetUserData", "NY_GetUserList", "NY_CreateRole", "NY_AddRoleToUser", "NY_RemoveRoleFromUser", "NY_DeleteRole", "NY_GetListOfRoles"};
        ZonedDateTime dateTime = ZonedDateTime.now();
        CSessionData sessionDataIn = new CSessionData(uuidData, "User123", values, dateTime);
        byte[] combined = CUtilSession.encodeSession(privateKey, sessionDataIn);
        System.out.println("Combined length: " + combined.length + " bytes");
        String s = CUtilBase64.encodeToString(combined);
        System.out.println("Base64 length: " + s.length() + " bytes:");
        System.out.println("Data sent...");
        boolean isValid = CUtilSession.verifySignature(combined, publicKey);
        System.out.println("Signature valid: " + isValid);
        CSessionData sessionData = CUtilSession.verifyAndDeserializeData(combined, publicKey);
        System.out.println("Extracted Token: " + CUtilByteArray.toString1(sessionData.getShortToken()));
        System.out.println("Extracted User ID: " + sessionData.getUserId());
        System.out.println("Extracted DateTime: " + String.valueOf(sessionData.getTimeStamp()));
        System.out.println("Permissions: " + CUtilStringArray.toString(sessionData.getRightIds(), ','));
    }
}

