/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilShort;
import de.sillysky.nyssr.util.CUtilShortArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotShortArray
implements ISlot,
ISingleSlotTypeFactory {
    private final short[] mValue;

    CSlotShortArray() {
        this.mValue = null;
    }

    private CSlotShortArray(short @Nullable [] aValue) {
        this.mValue = CUtilShortArray.copy(aValue);
    }

    @NotNull
    private static CSlotShortArray create(@Nullable Object aValue) {
        if (aValue instanceof short[]) {
            return new CSlotShortArray((short[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotShortArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotShortArray.fromList((List)aValue);
        }
        return new CSlotShortArray();
    }

    @NotNull
    private static CSlotShortArray fromList(@NotNull List<?> aList) {
        short[] array = CUtilShortArray.fromList(aList);
        return new CSlotShortArray(array);
    }

    @NotNull
    private static CSlotShortArray fromStream(@NotNull DataInput aStream) throws IOException {
        short[] array = CUtilShortArray.fromStream(aStream);
        return new CSlotShortArray(array);
    }

    @NotNull
    private static CSlotShortArray fromString(@NotNull String aValue) {
        short[] value = CUtilShortArray.fromString(aValue);
        return new CSlotShortArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotShortArray.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            short[] values = new short[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                values[i++] = CUtilShort.fromObject(child);
            }
            return new CSlotShortArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotShortArray other = (CSlotShortArray)aObj;
        return CUtilShortArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return short[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        short[] value = CUtilShortArray.copy(this.mValue);
        return new CSlotShortArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.SHORT_ARRAY;
    }

    public short @Nullable [] getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof short[]) {
            short[] bb = (short[])aValue;
            return CUtilShortArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotShortArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilShortArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilShortArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilShortArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (short i : this.mValue) {
                arr.add(i);
            }
            return arr;
        }
        return null;
    }
}

