/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.registry;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.target.monitor.CTargetMonitor;
import de.sillysky.nyssr.impl.target.registry.CTargetEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.message.logger.IMessageLoggerFactory;
import de.sillysky.nyssr.message.queue.IMessageQueue;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistry;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.target.monitor.ITargetMonitor;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordDataTargetInfo;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetRegistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

final class CTargetRegistry
implements ITargetRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetRegistry.class);
    private final Map<IId, CTargetEntry> mTargetMap = new HashMap<IId, CTargetEntry>();
    private INamespace mNamespace;
    private IMessageSender mMessageSender;
    private CTargetAddress mMyAddress = null;
    private CTargetMonitor mTargetMonitor;
    private IMessageQueueRegistry mMessageQueueRegistry;
    private IMessageLoggerFactory mMessageLoggerFactory;

    CTargetRegistry() {
    }

    void activate(@NotNull INamespace aNamespace, @NotNull IMessageQueueRegistry aMessageQueueRegistry, @NotNull IMessageSender aMessageSender, @NotNull IMessageLoggerFactory aMessageLoggerFactory, @NotNull IListenerRegistry aListenerRegistry) {
        this.mNamespace = aNamespace;
        this.mMessageSender = aMessageSender;
        this.mMessageQueueRegistry = aMessageQueueRegistry;
        this.mMessageLoggerFactory = aMessageLoggerFactory;
        CNamespaceAddress namespaceAddress = aNamespace.getAddress();
        this.mMyAddress = new CTargetAddress(CWellKnownTID.TARGET_REGISTRY, namespaceAddress);
        this.mTargetMonitor = new CTargetMonitor(this.mMessageSender, aListenerRegistry, namespaceAddress);
    }

    @Override
    public void addPendingMessage(CMessage aMsg) {
        CTargetAddress adr = aMsg.getEnvelope().getReceiver();
        IId tid = adr.getTID();
        CTargetEntry entry = this.ensureTargetEntry(tid);
        entry.addPendingMessage(aMsg);
    }

    private CRecord createTargetInfo(CTargetEntry aEntry) throws CException {
        CRecord rec = CRecordDataTargetInfo.create();
        CRecordDataTargetInfo.setClassName(rec, aEntry.getTarget().getClass().getName());
        CRecordDataTargetInfo.setClassSimpleName(rec, aEntry.getTarget().getClass().getSimpleName());
        CRecordDataTargetInfo.setQid(rec, aEntry.getQueue().getId());
        CRecordDataTargetInfo.setTid(rec, aEntry.getTarget().getAddress().getTID());
        return rec;
    }

    @Override
    public void deactivate() {
        this.mTargetMonitor.deactivate();
        CServiceRegistry.getInstance().deregisterService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterTarget(@NotNull IId aTID) {
        CTargetEntry entry;
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            entry = this.mTargetMap.get(aTID);
        }
        if (entry == null) {
            LOG.warn("Could not deregister target {}.", aTID);
        } else {
            ITarget tgt = entry.getTarget();
            if (tgt != null) {
                CTargetAddress address = tgt.getAddress();
                try {
                    tgt.notifyTargetWillBeRemoved();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Exception on will-be-deregister target: ");
                }
                this.sendNotifyTargetDeregistered(address, tgt.getName());
                entry.deregister();
                Map<IId, CTargetEntry> e = this.mTargetMap;
                synchronized (e) {
                    this.mTargetMap.remove(aTID);
                }
                LOG.debug("{} deregistered.", tgt);
                try {
                    tgt.notifyTargetDeRegistered();
                }
                catch (Exception e2) {
                    LOG.error((Throwable)e2, "Exception on deregister target: ");
                }
            }
        }
    }

    @Override
    public void deregisterTarget(@NotNull ITarget aTarget) {
        this.deregisterTarget(aTarget.getAddress().getTID());
    }

    @Override
    public void deregisterTarget(@NotNull CTargetAddress aAddress) {
        this.deregisterTarget(aAddress.getTID());
    }

    @Override
    public void dump(@NotNull ILogger aLogger) {
        TreeSet<String> tree = new TreeSet<String>();
        for (CTargetEntry e : this.mTargetMap.values()) {
            tree.add(e.toString());
        }
        for (String s : tree) {
            aLogger.debug(s);
        }
        aLogger.debug("--[{} Targets registered in namespace {}.{}]--", tree.size(), this.mMyAddress.getNID().toString(), this.mMyAddress.getNodeId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTargetEntry ensureTargetEntry(IId aTID) {
        CTargetEntry entry = this.getTargetEntry(aTID);
        if (entry == null) {
            CTargetAddress address = new CTargetAddress(aTID, this.mMyAddress.getNamespaceAddress());
            entry = new CTargetEntry(address);
            Map<IId, CTargetEntry> map = this.mTargetMap;
            synchronized (map) {
                this.mTargetMap.put(aTID, entry);
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTargetAddress[] getAddresses() {
        CTargetAddress[] arr;
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            int size = this.mTargetMap.size();
            arr = new CTargetAddress[size];
            int i = 0;
            for (Map.Entry<IId, CTargetEntry> entry : this.mTargetMap.entrySet()) {
                ITarget tgt = entry.getValue().getTarget();
                if (tgt != null) {
                    arr[i] = tgt.getAddress();
                }
                if (arr[i] == null) {
                    arr[i] = new CTargetAddress(entry.getKey(), this.mMyAddress.getNamespaceAddress());
                }
                ++i;
            }
        }
        return arr;
    }

    @Override
    @NotNull
    public ITargetMonitor getMonitor() {
        return this.mTargetMonitor;
    }

    @Override
    public IMessageQueue getQueue(@NotNull IId aTID) {
        CTargetEntry entry = this.getTargetEntry(aTID);
        if (entry == null) {
            return null;
        }
        return entry.getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IId getQueueId(@NotNull IId aTID) {
        CTargetEntry entry;
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            entry = this.mTargetMap.get(aTID);
        }
        if (entry == null) {
            return IId.INVALID;
        }
        return entry.getQueue().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IId[] getTIDs() {
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            int size = this.mTargetMap.size();
            IId[] arr = new IId[size];
            int i = 0;
            for (IId tid : this.mTargetMap.keySet()) {
                arr[i++] = tid;
            }
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IId @NotNull [] getTIDs(@NotNull IId aQID) {
        if (!aQID.isValid()) {
            LOG.error("getTIDs: Invalid queue id: {}", aQID);
            return new IId[0];
        }
        ArrayList<IId> list = new ArrayList<IId>();
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            for (CTargetEntry entry : this.mTargetMap.values()) {
                ITarget tgt;
                if (entry.getQueue().getId() != aQID || (tgt = entry.getTarget()) == null) continue;
                list.add(tgt.getAddress().getTID());
            }
        }
        IId[] result = new IId[list.size()];
        int i = 0;
        for (IId tid : list) {
            result[i++] = tid;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITarget getTarget(@NotNull IId aTID) {
        ITarget result = null;
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            CTargetEntry entry = this.mTargetMap.get(aTID);
            if (entry != null) {
                result = entry.getTarget();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTargetEntry getTargetEntry(IId aTID) {
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            return this.mTargetMap.get(aTID);
        }
    }

    @Override
    public CRecord @NotNull [] getTargetInfo(boolean aAll, @NotNull Collection<IId> aTIDs) throws CException {
        HashSet<CRecord> set = new HashSet<CRecord>();
        if (aAll) {
            for (CTargetEntry e : this.mTargetMap.values()) {
                set.add(this.createTargetInfo(e));
            }
        } else {
            for (IId tid : aTIDs) {
                CTargetEntry e = this.mTargetMap.get(tid);
                if (e == null) continue;
                set.add(this.createTargetInfo(e));
            }
        }
        int size = set.size();
        CRecord[] arr = new CRecord[size];
        set.toArray(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IId, String> getTargets() {
        HashMap<IId, String> targetMap = new HashMap<IId, String>();
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            for (Map.Entry<IId, CTargetEntry> entry : this.mTargetMap.entrySet()) {
                CTargetEntry targetEntry = entry.getValue();
                ITarget tgt = targetEntry.getTarget();
                if (tgt == null) continue;
                targetMap.put(entry.getKey(), targetEntry.getTarget().getClass().getSimpleName());
            }
            return targetMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTargetRegistered(@NotNull IId aTID) {
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            CTargetEntry e = this.mTargetMap.get(aTID);
            if (e != null && e.getTarget() != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<IId> iterator() {
        return this.mTargetMap.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyQueueDeregistered(@NotNull IId aQID) {
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            for (CTargetEntry target : this.mTargetMap.values()) {
                if (target.getQueue().getId() != aQID) continue;
                ITarget tgt = target.getTarget();
                this.deregisterTarget(tgt);
            }
        }
    }

    @Override
    public void notifyRegistered() {
        String filter = "nid=" + String.valueOf(this.mMyAddress.getNID());
        CServiceRegistry.getInstance().registerService(ITargetRegistry.class, filter, (Object)this);
    }

    @Override
    @NotNull
    public CTargetAddress registerTarget(@NotNull ITarget aTarget) throws CException {
        return this.registerTarget(aTarget, CIdFactory.randomOfType(EIdType.INT));
    }

    @Override
    @NotNull
    public CTargetAddress registerTarget(@NotNull ITarget aTarget, @NotNull IId aTID) throws CException {
        if (CIdFactory.isEmpty(aTID)) {
            return this.registerTarget(aTarget, CIdFactory.randomOfType(EIdType.INT));
        }
        return this.registerTarget(aTarget, aTID, IId.INVALID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CTargetAddress registerTarget(@NotNull ITarget aTarget, @NotNull IId aTID, @NotNull IId aQID) throws CException {
        CTargetEntry entry;
        IId tid = aTID;
        if (CIdFactory.isEmpty(tid)) {
            tid = CIdFactory.randomOfType(EIdType.INT);
        }
        if ((entry = this.getTargetEntry(tid)) != null && entry.getTarget() != null) {
            LOG.warn("    RegisterTarget: Target {} has already been registered.", tid);
            throw new CException(16).append("Target is already registered");
        }
        IMessageQueue queue = !aQID.isValid() ? this.mMessageQueueRegistry.getFirstQueue() : this.mMessageQueueRegistry.getQueue(aQID);
        if (queue == null) {
            LOG.error("    RegisterTarget: Unknown queue id: {}", aQID);
            throw new CException(2401).append("Unknown QueueID ").append(aQID);
        }
        CTargetAddress address = new CTargetAddress(tid, this.mMyAddress.getNamespaceAddress());
        if (entry == null) {
            entry = new CTargetEntry(address);
            Map<IId, CTargetEntry> map = this.mTargetMap;
            synchronized (map) {
                this.mTargetMap.put(tid, entry);
            }
        }
        entry.register(aTarget, queue);
        try {
            IMessageLogger logger = this.mMessageLoggerFactory.createLogger(aTarget);
            aTarget.notifyTargetRegistered(address, queue.getId(), this, this.mMessageSender, logger);
        }
        catch (CException e) {
            LOG.error("CException on notifyTargetRegistered for Target {}: Code={}, {}", address.toString(), e.getCode(), e);
        }
        catch (Exception e) {
            LOG.error("CException on notifyTargetRegistered for Target {}: {}", address.toString(), e);
        }
        this.sendNotifyTargetRegistered(aTarget, queue);
        this.sendStartTarget(address, queue.getId());
        entry.processPendingMessages();
        LOG.debug("    {} registered as [{}]", aTarget.getClass().getSimpleName(), address.toString());
        return address;
    }

    private void sendNotifyTargetDeregistered(CTargetAddress aAddress, String aName) {
        this.mTargetMonitor.triggerTargetRemoved(aAddress, aName);
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
            env.setSender(this.mMyAddress);
            CRecord rec = CRecordNotifyTargetDeregistered.create();
            CRecordNotifyTargetDeregistered.setAddress(rec, aAddress);
            this.mMessageSender.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error("Exception on sending message {} for Target {}: {}", CRecordNotifyTargetDeregistered.class.getSimpleName(), aAddress.toString(), e);
        }
    }

    private void sendNotifyTargetRegistered(@NotNull ITarget aTarget, @NotNull IMessageQueue aQueue) {
        CTargetAddress address = aTarget.getAddress();
        String name = aTarget.getName();
        String className = aTarget.getClass().getName();
        String simpleName = aTarget.getClass().getSimpleName();
        IId queueId = aQueue.getId();
        this.mTargetMonitor.triggerTargetAdded(address, name, className, simpleName, queueId);
        try {
            CEnvelope env = CEnvelope.forLocalNanoService(CWellKnownNID.SYSTEM);
            env.setSender(this.mMyAddress);
            CRecord rec = CRecordNotifyTargetRegistered.create();
            CRecordNotifyTargetRegistered.setAddress(rec, address);
            CRecordNotifyTargetRegistered.setClassName(rec, className);
            CRecordNotifyTargetRegistered.setSimpleClassName(rec, simpleName);
            CRecordNotifyTargetRegistered.setName(rec, name);
            CRecordNotifyTargetRegistered.setQueueId(rec, queueId);
            this.mMessageSender.sendNotification(env, rec);
        }
        catch (CException e) {
            LOG.error("Exception on sending message {} for Target {}: {}", CRecordNotifyTargetRegistered.class.getSimpleName(), address, e);
        }
    }

    private void sendStartTarget(CTargetAddress aAddress, IId aQID) {
        CEnvelope env = CEnvelope.forSingleTarget(aAddress);
        env.setSender(this.mMyAddress);
        try {
            CRecord rec = CRecordStartTarget.create();
            CRecordStartTarget.setMessageSender(rec, this.mMessageSender);
            CRecordStartTarget.setTargetRegistry(rec, this);
            CRecordStartTarget.setQid(rec, aQID);
            CRecordStartTarget.setTargetAddress(rec, aAddress);
            this.mMessageSender.sendNotification(env, rec);
        }
        catch (Exception e) {
            LOG.error("Exception on message StartTarget for Target {}: {}", aAddress, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<IId, CTargetEntry> map = this.mTargetMap;
        synchronized (map) {
            return this.mTargetMap.size();
        }
    }

    @Override
    @NotNull
    public INamespace getNamespace() {
        return this.mNamespace;
    }
}

