/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log.catcher.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordServiceLogCatcherAvailable
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("64974d0c-7dc8-4216-9d9a-c8a1428616ff");
    public static final String NAME = "ServiceLogCatcherAvailable";
    public static final String DESCRIPTION = "Notification that the log catcher is available (or not).";
    public static final String SLOT_AVAILABLE = "1";
    public static final String[] NAMESPACES = new String[]{"MONITOR"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getAvailable(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_AVAILABLE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static void setAvailable(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_AVAILABLE, slot);
    }
}

