/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNanoServiceGetServiceInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("850a6167-794b-414c-a566-dff1db2073db");
    public static final String NAME = "NanoServiceGetServiceInfo";
    public static final String DESCRIPTION = "Get nano service details.";
    public static final String SLOT_EXIST = "exist";
    public static final String SLOT_LAST_TRIGGER = "lt";
    public static final String SLOT_NAME = "name";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_OBSERVERS = "obs";
    public static final String SLOT_SID = "sid";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getExist(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_EXIST);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static CMessage getLastTrigger(@NotNull CRecord aRecord, CMessage aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LAST_TRIGGER);
        if (slot == null) {
            return aDefault;
        }
        return (CMessage)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress[] getObservers(@NotNull CRecord aRecord, CTargetAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVERS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress[])slot.getValue();
    }

    public static IId getSid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setExist(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_EXIST, slot);
    }

    public static void setLastTrigger(@NotNull CRecord aRecord, CMessage aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.MESSAGE, aValue);
        aRecord.addSlot(SLOT_LAST_TRIGGER, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setObservers(@NotNull CRecord aRecord, CTargetAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS_ARRAY, aValue);
        aRecord.addSlot(SLOT_OBSERVERS, slot);
    }

    public static void setSid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_SID, slot);
    }
}

