/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.notification.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyRemoteNodeRemoved
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("1d071671-a4aa-499d-bd6d-7d694a02e7e5");
    public static final String NAME = "NotifyRemoteNodeRemoved";
    public static final String DESCRIPTION = "Notification that a remote node has been removed.";
    public static final String SLOT_REMOTE_NODE = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CNodeAddress getRemoteNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static void setRemoteNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.NODE_ADDRESS, aValue);
        aRecord.addSlot(SLOT_REMOTE_NODE, slot);
    }
}

