/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.bytecarousel;

import de.sillysky.nyssr.util.bytecarousel.CByteCarouselInputStream;
import de.sillysky.nyssr.util.bytecarousel.CByteCarouselOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class CByteCarousel {
    private static final int MAX_BYTE = 255;
    private final CByteCarouselInputStream mIn = new CByteCarouselInputStream(this);
    private final CByteCarouselOutputStream mOut = new CByteCarouselOutputStream(this);
    private final int mConfigBytesToGrow;
    private byte[] mBuffer;
    private int mReadPos;
    private int mWritePos;
    private int mMarkPos;
    private int mMarkLimit = 0;

    public CByteCarousel() {
        this(1024);
    }

    public CByteCarousel(int aSize) {
        this(aSize, 1);
    }

    public CByteCarousel(int aSize, int aBytesToGrow) {
        this.mBuffer = new byte[aSize];
        this.mReadPos = 0;
        this.mWritePos = 0;
        this.mMarkPos = 0;
        this.mConfigBytesToGrow = aBytesToGrow > 0 ? aBytesToGrow : 1;
    }

    void checkMark() {
        int bytesMarked = this.getByteCountReadSinceMarked();
        if (bytesMarked > this.mMarkLimit) {
            this.mMarkLimit = 0;
            this.mMarkPos = this.mReadPos;
        }
    }

    private void ensureSize(int aBytesToWrite) {
        int free = this.getAvailableWrite();
        if (free < aBytesToWrite) {
            int newSize = this.mBuffer.length + aBytesToWrite + this.mConfigBytesToGrow;
            this.grow(newSize);
        }
    }

    public int getAvailableRead() {
        if (this.mReadPos <= this.mWritePos) {
            return this.mWritePos - this.mReadPos;
        }
        int empty = this.mReadPos - this.mWritePos;
        return this.mBuffer.length - empty;
    }

    private int getAvailableWrite() {
        if (this.mWritePos < this.mMarkPos) {
            return this.mMarkPos - this.mWritePos - 1;
        }
        int occupied = this.mWritePos - this.mMarkPos;
        return this.mBuffer.length - occupied - 1;
    }

    private int getByteCountReadSinceMarked() {
        int readSinceMarked;
        if (this.mMarkPos <= this.mReadPos) {
            readSinceMarked = this.mReadPos - this.mMarkPos;
        } else {
            int unmarked = this.mMarkPos - this.mReadPos;
            readSinceMarked = this.mBuffer.length - unmarked;
        }
        return readSinceMarked;
    }

    public int getCapacity() {
        return this.mBuffer.length;
    }

    public InputStream getInputStream() {
        return this.mIn;
    }

    public OutputStream getOutputStream() {
        return this.mOut;
    }

    private void grow(int aByteCountToGrow) {
        int newSize = this.mBuffer.length + aByteCountToGrow;
        byte[] bufNew = new byte[newSize];
        int availableRead = this.getAvailableRead();
        if (this.mMarkPos <= this.mWritePos) {
            int lenContent = this.mWritePos - this.mMarkPos;
            System.arraycopy(this.mBuffer, this.mMarkPos, bufNew, 0, lenContent);
        } else {
            int lenContentFirstPart = this.mBuffer.length - this.mMarkPos;
            System.arraycopy(this.mBuffer, this.mMarkPos, bufNew, 0, lenContentFirstPart);
            int lenContentSecondPart = this.mWritePos;
            System.arraycopy(this.mBuffer, 0, bufNew, lenContentFirstPart, lenContentSecondPart);
        }
        int readSinceMarked = this.getByteCountReadSinceMarked();
        this.mMarkPos = 0;
        this.mReadPos = readSinceMarked;
        this.mWritePos = readSinceMarked + availableRead;
        this.mBuffer = bufNew;
    }

    private void growReadPos(int aCount) {
        this.mReadPos += aCount;
        if (this.mReadPos >= this.mBuffer.length) {
            this.mReadPos -= this.mBuffer.length;
        }
    }

    private void growWritePos(int aCount) {
        this.mWritePos += aCount;
        if (this.mWritePos >= this.mBuffer.length) {
            this.mWritePos -= this.mBuffer.length;
        }
    }

    void mark(int aLimit) {
        int maxRead = this.getAvailableRead();
        this.mMarkLimit = Math.min(aLimit, maxRead);
        this.mMarkPos = this.mReadPos;
    }

    int read() {
        int result;
        int availableRead = this.getAvailableRead();
        if (availableRead > 0) {
            result = this.mBuffer[this.mReadPos] & 0xFF;
            this.growReadPos(1);
            this.checkMark();
        } else {
            result = -1;
        }
        return result;
    }

    int read(byte[] aDestination, int aStartPos, int aBytesToRead) {
        int result;
        int availableRead = this.getAvailableRead();
        if (availableRead > 0) {
            int bytesToRead = Math.min(aBytesToRead, availableRead);
            if (bytesToRead > 0) {
                int chunkSize2;
                int chunkSize1 = Math.min(bytesToRead, this.mBuffer.length - this.mReadPos);
                if (chunkSize1 > 0) {
                    System.arraycopy(this.mBuffer, this.mReadPos, aDestination, aStartPos, chunkSize1);
                    this.growReadPos(chunkSize1);
                }
                if ((chunkSize2 = bytesToRead - chunkSize1) > 0) {
                    System.arraycopy(this.mBuffer, 0, aDestination, aStartPos + chunkSize1, chunkSize2);
                    this.growReadPos(chunkSize2);
                }
                this.checkMark();
                result = bytesToRead;
            } else {
                result = 0;
            }
        } else {
            result = -1;
        }
        return result;
    }

    void reset() {
        this.mReadPos = this.mMarkPos;
    }

    public void reuse() {
        this.mMarkPos = 0;
        this.mWritePos = 0;
        this.mReadPos = 0;
        this.mIn.reuse();
        this.mOut.reuse();
    }

    long skip(long aBytesToSkip) {
        long result;
        int availableRead = this.getAvailableRead();
        if (availableRead > 0) {
            int len = Math.min((int)aBytesToSkip, availableRead);
            this.growReadPos(len);
            this.checkMark();
            result = len;
        } else {
            result = 0L;
        }
        return result;
    }

    void write(byte[] aSource, int aStartPos, int aBytesToWrite) {
        this.ensureSize(aBytesToWrite);
        int bytesToWrite = aBytesToWrite;
        int writeLen = Math.min(aBytesToWrite, this.mBuffer.length - this.mWritePos);
        if (writeLen > 0) {
            System.arraycopy(aSource, aStartPos, this.mBuffer, this.mWritePos, writeLen);
            bytesToWrite -= writeLen;
            this.growWritePos(writeLen);
        }
        if (bytesToWrite > 0) {
            System.arraycopy(aSource, aStartPos + writeLen, this.mBuffer, 0, bytesToWrite);
            this.growWritePos(bytesToWrite);
        }
    }

    void write(int aByte) {
        byte value;
        this.ensureSize(1);
        this.mBuffer[this.mWritePos] = value = (byte)(aByte & 0xFF);
        this.growWritePos(1);
    }
}

