/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NotNull;

class CTableCellEditorDecimal
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -3494121872366842755L;
    private final CTable mTable;
    private final JFormattedTextField mTextField;
    private final String mFormat;

    CTableCellEditorDecimal(@NotNull CTable aTable, @NotNull CColumn aColumn) {
        this.mTable = aTable;
        String format = aColumn.getFormat();
        this.mFormat = CUtilString.isEmpty((String)format) ? "###########0.#########" : format;
        this.mTextField = new JFormattedTextField();
        this.mTextField.setMargin(new Insets(0, 5, 0, 5));
    }

    @Override
    public Component getTableCellEditorComponent(JTable aTable, Object aValue, boolean aIsSelected, int aRowIndex, int aColumnIndex) {
        double theValue = CUtilDouble.fromObject((Object)aValue, (double)0.0);
        this.mTextField.setValue(theValue);
        this.mTextField.setHorizontalAlignment(4);
        NumberFormatter displayFormatter = new NumberFormatter();
        displayFormatter.setValueClass(Double.class);
        NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat(this.mFormat));
        editFormatter.setValueClass(Double.class);
        this.mTextField.setFormatterFactory(new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter));
        return this.mTextField;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            this.mTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.mTextField.getValue();
    }
}

