/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingComponent;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventBorderLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventBoxLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventCardLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventFlowLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventGridBagLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventGridLayout;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventLayoutConstraints;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventMigLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.BoxLayout;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingContainer
extends CSwingComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingContainer.class);

    CSwingContainer(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("constraints", this::applyConstraint);
        list.addHandler("borderLayout", this::applyBorderLayout);
        list.addHandler("boxLayout", this::applyBoxLayout);
        list.addHandler("cardLayout", this::applyCardLayout);
        list.addHandler("flowLayout", this::applyFlowLayout);
        list.addHandler("gridBagLayout", this::applyGridBagLayout);
        list.addHandler("gridLayout", this::applyGridLayout);
        list.addHandler("migLayout", this::applyMigLayout);
    }

    public void addChildComponent(@NotNull CWidget aChild) {
        Container parentContainer = this.getContentPane();
        if (parentContainer == null) {
            LOG.error("Couldn't add child: parentContainer is null. parentId = {}, childId = {}", new Object[]{this.getId(), aChild.getId()});
            return;
        }
        Component child = aChild.getComponent();
        if (child instanceof Window) {
            LOG.debug("Couldn't add child: child is a Window. parentId = {}, childId = {}", new Object[]{this.getId(), aChild.getId()});
            return;
        }
        Object o = aChild.getProperties().get("constraints");
        if (o instanceof CEventLayoutConstraints) {
            CEventLayoutConstraints event = (CEventLayoutConstraints)o;
            int index = event.getIndex();
            Object constraints = event.getConstraints();
            LOG.info("{}: add {} index={} constraints={}", new Object[]{this.getId(), aChild.getId(), index, constraints == null ? "null" : constraints});
            if (index >= 0) {
                if (constraints != null) {
                    parentContainer.add(child, constraints, index);
                } else {
                    parentContainer.add(child, index);
                }
            } else if (constraints != null) {
                parentContainer.add(child, constraints);
            } else {
                parentContainer.add(child);
            }
        } else {
            parentContainer.add(child);
        }
        this.notifyWidget(ENotification.GOT_CHILD, aChild);
        aChild.notifyChildren(ENotification.GOT_PARENT, new Object[]{this});
    }

    private boolean applyBorderLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventBorderLayout event = CEventBorderLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            int horizontalGap = event.getHorizontalGap();
            int verticalGap = event.getVerticalGap();
            container.setLayout(new BorderLayout(horizontalGap, verticalGap));
            return true;
        }
        return false;
    }

    private boolean applyBoxLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventBoxLayout event = CEventBoxLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout(new BoxLayout(container, event.getSwingAxis()));
            return true;
        }
        return false;
    }

    private boolean applyCardLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventCardLayout event = CEventCardLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout(new CardLayout(event.getHorizontalGap(), event.getVerticalGap()));
            return true;
        }
        return false;
    }

    private boolean applyFlowLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventFlowLayout event = CEventFlowLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout(new FlowLayout(event.getSwingAlignment(), event.getHorizontalGap(), event.getVerticalGap()));
            return true;
        }
        return false;
    }

    private boolean applyGridBagLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventGridBagLayout event = CEventGridBagLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout(new GridBagLayout());
        }
        return true;
    }

    private boolean applyGridLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventGridLayout event = CEventGridLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout(new GridLayout(event.getRows(), event.getColumns(), event.getHorizontalGap(), event.getVerticalGap()));
        }
        return true;
    }

    private boolean applyMigLayout(@NotNull String aKey, @Nullable Object aValue) {
        CEventMigLayout event = CEventMigLayout.create((Object)aValue);
        if (event != null) {
            Container container = (Container)this.getComponent();
            container.setLayout((LayoutManager)new MigLayout(event.getLayoutConstraints(), event.getColumnConstraints(), event.getRowConstraints()));
        }
        return true;
    }

    private boolean applyConstraint(@NotNull String aKey, @Nullable Object aValue) {
        CEventLayoutConstraints event = CEventLayoutConstraints.create((Object)aValue);
        if (event != null) {
            this.getProperties().put(aKey, event);
        }
        return true;
    }

    @Nullable
    public Container getContentPane() {
        Component component = this.getComponent();
        if (component instanceof Container) {
            return (Container)component;
        }
        return null;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Unknown.name();
    }
}

