/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingMenuItem;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventComponentOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertMenuItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventLayoutConstraints;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.ComponentOrientation;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingMenu
extends CSwingMenuItem {
    private final JMenu mComponent = new JMenu();

    public CSwingMenu(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("componentOrientation", this::applyComponentOrientation);
        list.addHandler("delay", this::applyDelay);
        list.addHandler("doClick", this::applyDoClick);
        list.addHandler("insertMenuItem", this::applyInsertMenuItem);
        list.addHandler("popupVisible", this::applyPopupVisible);
        list.addHandler("selected", this::applySelected);
    }

    private boolean applyComponentOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventComponentOrientation event = CEventComponentOrientation.create((Object)aValue);
        if (event != null) {
            switch (event.getComponentOrientation()) {
                case WesternEurope: {
                    this.mComponent.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    break;
                }
                case MiddleEast: {
                    this.mComponent.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    break;
                }
                default: {
                    this.mComponent.setComponentOrientation(ComponentOrientation.UNKNOWN);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyDelay(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int delay = CUtilInteger.fromObject((Object)aValue, (int)200);
            this.mComponent.setDelay(delay);
            return true;
        }
        return false;
    }

    private boolean applyDoClick(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int pressTime = CUtilInteger.fromObject((Object)aValue, (int)0);
            this.mComponent.doClick(pressTime);
            return true;
        }
        return false;
    }

    private boolean applyInsertMenuItem(@NotNull String aKey, @Nullable Object aValue) throws Exception {
        CEventInsertMenuItem event = CEventInsertMenuItem.create((Object)aValue);
        if (event != null) {
            CEventWidgetId id = event.getId();
            CEventLayoutConstraints lc = new CEventLayoutConstraints();
            lc.setIndex(event.getPosition());
            CWidget widget = this.getWidgetSet().getContext().createWidget(EWidgetTypes.MenuItem.name(), id.getWidgetId(), this.getId(), lc);
            if (widget != null) {
                CEventText eventText = event.getEventText();
                String text = eventText.getText();
                JMenuItem menuItem = (JMenuItem)widget.getComponent();
                menuItem.setText(text);
                return true;
            }
        }
        return false;
    }

    private boolean applyPopupVisible(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean visible = CUtilBoolean.fromObject((Object)aValue, (boolean)false);
            this.mComponent.setPopupMenuVisible(visible);
            return true;
        }
        return false;
    }

    private boolean applySelected(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean selected = CUtilBoolean.fromObject((Object)aValue, (boolean)false);
            this.mComponent.setSelected(selected);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JMenu getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Menu.name();
    }
}

