/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumnModel;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellEditor;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellEditorBoolean;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellEditorDecimal;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellEditorText;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellRendererBoolean;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableCellRendererDecimal;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeaderEntry;
import de.sillysky.nyssr.remoteskin.model.enums.EColumnType;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CColumn {
    private static final long serialVersionUID = -6810760769146307674L;
    private final String mId;
    private final CColumnModel mColumnModel;
    private final CTableHeaderEntry mHeader;
    private final TableColumn mSwingColumn;
    private EColumnType mType = EColumnType.text;
    private String mFormat = null;
    private boolean mEditable = false;
    private boolean mSizeWidthToFit = false;
    private Color mBackground = UIManager.getColor("table.background");
    private Color mForeground = UIManager.getColor("table.foreground");
    private Border mBorder = null;
    private Font mFont;

    CColumn(@NotNull CColumnModel aColumnModel, @NotNull String aId, int aIndex) {
        this.mId = aId;
        this.mColumnModel = aColumnModel;
        this.mSwingColumn = new TableColumn(aIndex);
        this.mColumnModel.getSwingColumnModel().addColumn(this.mSwingColumn);
        this.mHeader = new CTableHeaderEntry(this);
        this.mSwingColumn.setCellRenderer(new CTableCellRenderer(this.getTable()));
        this.mSwingColumn.setCellEditor(new CTableCellEditor(this.getTable()));
    }

    @NotNull
    public String getId() {
        return this.mId;
    }

    @NotNull
    CTable getTable() {
        return this.mColumnModel.getTableModel().getTable();
    }

    @NotNull
    CTableHeaderEntry getHeader() {
        return this.mHeader;
    }

    public boolean isEditable() {
        return this.mEditable;
    }

    public void setEditable(boolean aEditable) {
        this.mEditable = aEditable;
    }

    public EColumnType getType() {
        return this.mType;
    }

    public void setType(EColumnType aType) {
        this.mType = aType;
    }

    @Nullable
    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(@Nullable String aFormat) {
        this.mFormat = aFormat;
    }

    public Color getBackground() {
        return this.mBackground;
    }

    public void setBackground(Color aBackground) {
        this.mBackground = aBackground;
    }

    public Color getForeground() {
        return this.mForeground;
    }

    public void setForeground(Color aForeground) {
        this.mForeground = aForeground;
    }

    public Border getBorder() {
        return this.mBorder;
    }

    public void setBorder(Border aBorder) {
        this.mBorder = aBorder;
    }

    public Font getFont() {
        return this.mFont;
    }

    public void setFont(Font aFont) {
        this.mFont = aFont;
    }

    public Border getTreeBorder() {
        return this.mBorder == null ? this.getTable().getCellDefaultBorder() : this.mBorder;
    }

    public Color getTreeBackground() {
        return this.mBackground == null ? this.getTable().getCellDefaultBackground() : this.mBackground;
    }

    public Color getTreeForeground() {
        return this.mForeground == null ? this.getTable().getCellDefaultForeground() : this.mForeground;
    }

    public Font getTreeFont() {
        return this.mFont == null ? this.getTable().getCellDefaultFont() : this.mFont;
    }

    public void finish() {
        switch (this.mType) {
            case bool: {
                this.mSwingColumn.setCellRenderer(new CTableCellRendererBoolean(this.getTable()));
                this.mSwingColumn.setCellEditor(new CTableCellEditorBoolean(this.getTable()));
                break;
            }
            case decimal: {
                this.mSwingColumn.setCellRenderer(new CTableCellRendererDecimal(this.getTable()));
                this.mSwingColumn.setCellEditor(new CTableCellEditorDecimal(this.getTable(), this));
                break;
            }
            default: {
                this.mSwingColumn.setCellRenderer(new CTableCellRenderer(this.getTable()));
                this.mSwingColumn.setCellEditor(new CTableCellEditorText(this.getTable()));
            }
        }
        if (this.mSizeWidthToFit) {
            this.mSwingColumn.sizeWidthToFit();
        }
    }

    public boolean isSizeWidthToFit() {
        return this.mSizeWidthToFit;
    }

    public void setSizeWidthToFit(boolean aSizeWidthToFit) {
        this.mSizeWidthToFit = aSizeWidthToFit;
    }

    public void setResizable(boolean aResizable) {
        this.mSwingColumn.setResizable(aResizable);
    }

    public void setMinWidth(int aMinimumWidth) {
        this.mSwingColumn.setMinWidth(aMinimumWidth);
    }

    public void setMaxWidth(int aMaximumWidth) {
        this.mSwingColumn.setMaxWidth(aMaximumWidth);
    }

    public void setPreferredWidth(int aPreferredWidth) {
        this.mSwingColumn.setPreferredWidth(aPreferredWidth);
    }

    public void sizeWidthToFit() {
        this.mSwingColumn.sizeWidthToFit();
    }
}

