/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CColumn;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTable;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeader;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.table.CTableHeaderEntry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.icon.CUtilIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class CTableHeaderCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -8690656968714509310L;
    private final ImageIcon mUp;
    private final ImageIcon mDown;
    private final CTable mTable;

    public CTableHeaderCellRenderer(CTable aTable) {
        this.mTable = aTable;
        this.mUp = CUtilIcon.loadIcon(this.getClass(), (String)"images/triangle-up.png", (String)"up");
        this.mDown = CUtilIcon.loadIcon(this.getClass(), (String)"images/triangle-down.png", (String)"down");
    }

    @Override
    public Component getTableCellRendererComponent(@NotNull JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRowIndex, int aColumnIndex) {
        return this.getComponentWithSortingIcon(aTable, aColumnIndex);
    }

    private Component getComponentWithSortingIcon(@NotNull JTable aTable, int aColumnIndex) {
        CTableHeader tableHeader = this.mTable.getMyTableHeader();
        CColumn column = this.mTable.getMyModel().getColumnModel().getColumnByIndex(aColumnIndex);
        JPanel p = new JPanel((LayoutManager)new MigLayout());
        if (column != null) {
            RowSorter<? extends TableModel> rowSorter;
            String text;
            ImageIcon icon;
            CTableHeaderEntry header = column.getHeader();
            Color foreground = header.getForeground();
            String tt = header.getToolTip();
            if (CUtilString.isValid((String)tt)) {
                p.setToolTipText(tt);
            }
            Border border = header.getBorder();
            p.setBorder(border);
            Color background = header.getBackground();
            if (background != null) {
                p.setBackground(background);
            }
            if ((icon = header.getIcon()) != null) {
                JLabel iconLabel = new JLabel(icon);
                p.add(iconLabel);
            }
            if (CUtilString.isValid((String)(text = header.getText()))) {
                Font font;
                JLabel textLabel = new JLabel(text);
                textLabel.setOpaque(false);
                if (foreground != null) {
                    textLabel.setForeground(foreground);
                }
                if ((font = header.getFont()) != null) {
                    textLabel.setFont(font);
                }
                p.add(textLabel);
            }
            if ((rowSorter = aTable.getRowSorter()) != null) {
                List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
                int no = 0;
                for (RowSorter.SortKey key : sortKeys) {
                    if (key.getColumn() == aColumnIndex) {
                        ImageIcon sortIcon = this.getSortIcon(key);
                        String sortNumberText = Integer.toString(no + 1);
                        JLabel sortLabel = new JLabel(sortNumberText, sortIcon, 11);
                        if (foreground != null) {
                            sortLabel.setForeground(foreground);
                        }
                        p.add(sortLabel);
                    }
                    ++no;
                }
            }
        }
        return p;
    }

    private ImageIcon getSortIcon(RowSorter.SortKey aKey) {
        SortOrder sortOrder = aKey.getSortOrder();
        if (sortOrder.compareTo(SortOrder.ASCENDING) == 0) {
            return this.mDown;
        }
        if (sortOrder.compareTo(SortOrder.DESCENDING) == 0) {
            return this.mUp;
        }
        return null;
    }
}

