/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CNodeRenderer;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingNode;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTree;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTreeNode;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTreeOfNodes;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CUtilConvertTreeNodes;
import de.sillysky.nyssr.impl.remoteskin.client.util.CIconHandler;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.enums.EEditChangeType;
import de.sillysky.nyssr.remoteskin.model.enums.EIconUsage;
import de.sillysky.nyssr.remoteskin.model.enums.ERelation;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventEnsureVisible;
import de.sillysky.nyssr.remoteskin.model.events.CEventExpansionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventIdAndValue;
import de.sillysky.nyssr.remoteskin.model.events.CEventInsertTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectItems;
import de.sillysky.nyssr.remoteskin.model.events.CEventSetRowHeight;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeNode;
import de.sillysky.nyssr.remoteskin.model.events.CEventTreeSelectionMode;
import de.sillysky.nyssr.util.CUtilInteger;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingTree
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTree.class);
    private final CTree mComponent = new CTree(this);
    private final CTreeOfNodes mNodes;
    private final CIconHandler mIconHandler;
    private boolean mWantSelectionChange = false;
    private boolean mExpansionChangeListenerAdded = false;
    private boolean mUseSingleNodeRenderer = true;
    private boolean mTreeModelListenerInstalled = false;

    public CSwingTree(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.mComponent.setCellRenderer(new CNodeRenderer(this));
        this.mNodes = new CTreeOfNodes(this.mComponent);
        this.mIconHandler = new CIconHandler(this){

            @Override
            public void setIcon(@NotNull Icon aIcon, EIconUsage aUsage) {
                switch (aUsage) {
                    case default_leaf: {
                        CNodeRenderer renderer = CSwingTree.this.getCellRenderer();
                        renderer.setLeafIcon(aIcon);
                        break;
                    }
                    case default_open: {
                        CNodeRenderer renderer = CSwingTree.this.getCellRenderer();
                        renderer.setOpenIcon(aIcon);
                        break;
                    }
                    case default_closed: {
                        CNodeRenderer renderer = CSwingTree.this.getCellRenderer();
                        renderer.setClosedIcon(aIcon);
                        break;
                    }
                }
            }
        };
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("clear", this::applyClear);
        list.addHandler("treeInsertNode", this::applyTreeInsertNode);
        list.addHandler("treeSetNodes", this::applyTreeSetNodes);
        list.addHandler("nodes", this::applyTreeSetNodes);
        list.addHandler("treeRootVisible", this::applyTreeRootVisible);
        list.addHandler("treeShowLines", this::applyTreeShowLines);
        list.addHandler("treeDefaultLeafIcon", this::applyTreeDefaultLeafIcon);
        list.addHandler("treeDefaultOpenIcon", this::applyTreeDefaultOpenIcon);
        list.addHandler("treeDefaultClosedIcon", this::applyTreeDefaultClosedIcon);
        list.addHandler("nodeBackground", this::applyTreeNodeBackground);
        list.addHandler("treeSingleNodeRenderer", this::applySingleNodeRenderer);
        list.addHandler("treeSelectionMode", this::applyTreeSelectionMode);
        list.addHandler("wantSelectionChange", this::applyWantSelectionChange);
        list.addHandler("treeMakeNodeViewable", this::applyMakeNodeVisible);
        list.addHandler("selectItem", this::applySelectItem);
        list.addHandler("selectItems", this::applySelectItems);
        list.addHandler("clearSelection", this::applyClearSelection);
        list.addHandler("wantExpansionChange", this::applyWantExpansionChange);
        list.addHandler("collapse", this::applyCollapse);
        list.addHandler("expand", this::applyExpand);
        list.addHandler("ensureVisible", this::applyEnsureVisible);
        list.addHandler("editable", this::applyEditable);
        list.addHandler("wantChange", this::applyWantChange);
        list.addHandler("stopEditing", this::applyStopEditing);
        list.addHandler("startEditing", this::applyStartEditing);
        list.addHandler("treeToggleClickCount", this::applyToggleClickCount);
        list.addHandler("visibleRowCount", this::applyVisibleRowCount);
        list.addHandler("treeShowRootHandles", this::applyShowRootHandles);
        list.addHandler("treeScrollsOnExpand", this::applyScrollsOnExpand);
        list.addHandler("rowHeight", this::applyRowHeight);
        list.addHandler("icon", this::applyIcon);
        list.addHandler("icons", this::applyIcons);
    }

    private boolean applyRowHeight(@NotNull String aKey, @Nullable Object aValue) {
        CEventSetRowHeight event = CEventSetRowHeight.create((Object)aValue);
        if (event != null) {
            int rowHeight = event.getHeight();
            this.getComponent().setRowHeight(rowHeight);
            return true;
        }
        return false;
    }

    private boolean applyScrollsOnExpand(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.getComponent().setScrollsOnExpand(enabled);
            return true;
        }
        return false;
    }

    private boolean applyShowRootHandles(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.getComponent().setShowsRootHandles(enabled);
            return true;
        }
        return false;
    }

    private boolean applyVisibleRowCount(@NotNull String aKey, @Nullable Object aValue) {
        int rowCount;
        if ((aValue instanceof Number || aValue instanceof String) && (rowCount = CUtilInteger.fromObject((Object)aValue, (int)-1)) > 0) {
            this.getComponent().setVisibleRowCount(rowCount);
            return true;
        }
        return false;
    }

    private boolean applyToggleClickCount(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number || aValue instanceof String) {
            int clickCount = CUtilInteger.fromObject((Object)aValue, (int)1);
            this.getComponent().setToggleClickCount(clickCount);
            return true;
        }
        return false;
    }

    private boolean applyStartEditing(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String id = (String)aValue;
            CTreeNode node = this.mNodes.get(id);
            if (node == null) {
                LOG.warn("Tree start editing: ID {} not found", new Object[]{id});
            } else {
                TreePath treePath = new TreePath(node.getSwingNode().getPath());
                this.getComponent().startEditingAtPath(treePath);
                return true;
            }
        }
        return false;
    }

    private boolean applyStopEditing(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.getComponent().stopEditing();
            return true;
        }
        return false;
    }

    private boolean applyWantChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled && !this.mTreeModelListenerInstalled) {
                this.mTreeModelListenerInstalled = true;
                this.getComponent().getModel().addTreeModelListener(new TreeModelListener(){

                    @Override
                    public void treeNodesChanged(TreeModelEvent e) {
                        this.send(e, EEditChangeType.change);
                    }

                    @Override
                    public void treeNodesInserted(TreeModelEvent e) {
                        this.send(e, EEditChangeType.insert);
                    }

                    @Override
                    public void treeNodesRemoved(TreeModelEvent e) {
                        this.send(e, EEditChangeType.remove);
                    }

                    @Override
                    public void treeStructureChanged(TreeModelEvent e) {
                    }

                    private void send(@NotNull TreeModelEvent aEvent, EEditChangeType aType) {
                        CEventTreeChangeNotification event = new CEventTreeChangeNotification(aType);
                        TreePath parentPath = aEvent.getTreePath();
                        Object[] children = aEvent.getChildren();
                        if (children == null) {
                            CTreeNode root = CSwingTree.this.mNodes.getRootNode();
                            if (root != null) {
                                event.addValue(new CEventIdAndValue(root.getId(), root.getSwingNode().getUserObject()));
                            }
                        } else {
                            CTreeNode parent = CSwingTree.this.mNodes.getNodeByPath(parentPath);
                            for (Object o : children) {
                                if (!(o instanceof CSwingNode)) continue;
                                CSwingNode n = (CSwingNode)o;
                                CTreeNode node = n.getNode();
                                Object o1 = node.getSwingNode().getUserObject();
                                event.addValue(new CEventIdAndValue(node.getId(), o1));
                            }
                            CSwingTree.this.addNotification("onTreeChange", event.toJson());
                            CSwingTree.this.sendNotification();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private boolean applyEnsureVisible(@NotNull String aKey, @Nullable Object aValue) {
        CEventEnsureVisible event = CEventEnsureVisible.create((Object)aValue);
        if (event != null) {
            String id = event.getId();
            CTreeNode node = this.mNodes.get(id);
            if (node != null) {
                TreePath treePath = node.getTreePath();
                this.getComponent().scrollPathToVisible(treePath);
                return true;
            }
            LOG.warn("Make Item visible: Node not found: {}", new Object[]{id});
        }
        return false;
    }

    private boolean applyCollapse(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String id = (String)aValue;
            CTreeNode node = this.mNodes.get(id);
            if (node != null) {
                TreePath treePath = node.getTreePath();
                this.getComponent().collapsePath(treePath);
                return true;
            }
            LOG.warn("Tree node collapse: Node not found: {}", new Object[]{id});
        }
        return false;
    }

    private boolean applyExpand(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String id = (String)aValue;
            CTreeNode node = this.mNodes.get(id);
            if (node != null) {
                TreePath treePath = node.getTreePath();
                this.getComponent().expandPath(treePath);
                return true;
            }
            LOG.warn("Tree node expand: Node not found: {}", new Object[]{id});
        }
        return false;
    }

    private boolean applyEditable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            this.getComponent().setEditable(enabled);
            return true;
        }
        return false;
    }

    private boolean applyClearSelection(@NotNull String aKey, @Nullable Object aValue) {
        boolean clear;
        if (aValue instanceof Boolean && (clear = ((Boolean)aValue).booleanValue())) {
            TreeSelectionModel selectionModel = this.getComponent().getSelectionModel();
            selectionModel.clearSelection();
        }
        return false;
    }

    private boolean applySelectItem(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectItem event = CEventSelectItem.create((Object)aValue);
        if (event != null) {
            TreeSelectionModel selectionModel = this.getComponent().getSelectionModel();
            selectionModel.clearSelection();
            String nodeId = event.getItemId();
            TreePath treePath = this.getTreePath(nodeId);
            if (treePath != null) {
                selectionModel.setSelectionPath(treePath);
                return true;
            }
        }
        return false;
    }

    private boolean applySelectItems(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectItems event = CEventSelectItems.create((Object)aValue);
        if (event != null) {
            TreeSelectionModel selectionModel = this.getComponent().getSelectionModel();
            selectionModel.clearSelection();
            Collection nodeIds = event.getItemIds();
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (String nodeId : nodeIds) {
                TreePath treePath = this.getTreePath(nodeId);
                if (treePath == null) continue;
                paths.add(treePath);
            }
            if (!paths.isEmpty()) {
                selectionModel.setSelectionPaths(paths.toArray(new TreePath[0]));
                return true;
            }
        }
        return false;
    }

    private boolean applyMakeNodeVisible(@NotNull String aKey, @Nullable Object aValue) {
        String id;
        CTreeNode node;
        if (aValue instanceof String && (node = this.mNodes.get(id = (String)aValue)) != null) {
            LOG.debug("Tree: Make node {} visible", new Object[]{id});
            this.getComponent().makeVisible(new TreePath(node.getSwingNode().getPath()));
            return true;
        }
        return false;
    }

    private boolean applyWantSelectionChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mWantSelectionChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyWantExpansionChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean wantExpansionChange = (Boolean)aValue;
            if (wantExpansionChange && !this.mExpansionChangeListenerAdded) {
                this.mExpansionChangeListenerAdded = true;
                this.getComponent().addTreeExpansionListener(new TreeExpansionListener(){

                    @Override
                    public void treeExpanded(TreeExpansionEvent aEvent) {
                        TreePath path = aEvent.getPath();
                        CTreeNode node = CSwingTree.this.mNodes.getNodeByPath(path);
                        if (node != null) {
                            CEventExpansionNotification event = new CEventExpansionNotification(node.getId(), true);
                            CSwingTree.this.addNotification("onExpansion", event.toJson());
                            CSwingTree.this.sendNotification();
                        }
                    }

                    @Override
                    public void treeCollapsed(TreeExpansionEvent aEvent) {
                        TreePath path = aEvent.getPath();
                        CTreeNode node = CSwingTree.this.mNodes.getNodeByPath(path);
                        if (node != null) {
                            CEventExpansionNotification event = new CEventExpansionNotification(node.getId(), false);
                            CSwingTree.this.addNotification("onExpansion", event.toJson());
                            CSwingTree.this.sendNotification();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    boolean wantSelect() {
        return this.mWantSelectionChange;
    }

    private boolean applyTreeSelectionMode(@NotNull String aKey, @Nullable Object aValue) {
        CEventTreeSelectionMode event = CEventTreeSelectionMode.create((Object)aValue);
        if (event != null) {
            TreeSelectionModel selectionModel = this.getComponent().getSelectionModel();
            switch (event.getSelectionMode()) {
                case single: {
                    selectionModel.setSelectionMode(1);
                    return true;
                }
                case singleinterval: {
                    selectionModel.setSelectionMode(2);
                    return true;
                }
                case multipleintervals: {
                    selectionModel.setSelectionMode(4);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean applySingleNodeRenderer(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mUseSingleNodeRenderer = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyClear(@NotNull String aKey, @Nullable Object aValue) {
        boolean enabled;
        if (aValue instanceof Boolean && (enabled = ((Boolean)aValue).booleanValue())) {
            this.mNodes.clear();
        }
        return false;
    }

    private boolean applyTreeNodeBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            this.getCellRenderer().setBackground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue);
    }

    private boolean applyIcons(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvents(aValue);
    }

    private boolean applyTreeDefaultClosedIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue, EIconUsage.default_closed);
    }

    private boolean applyTreeDefaultOpenIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue, EIconUsage.default_open);
    }

    private boolean applyTreeDefaultLeafIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue, EIconUsage.default_leaf);
    }

    private boolean applyTreeShowLines(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean showLines = (Boolean)aValue;
            if (showLines) {
                this.mComponent.putClientProperty("JTree.lineStyle", "Horizontal");
            } else {
                this.mComponent.putClientProperty("JTree.lineStyle", "None");
            }
            return true;
        }
        return false;
    }

    private boolean applyTreeRootVisible(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean rootVisible = (Boolean)aValue;
            this.mComponent.setRootVisible(rootVisible);
            return true;
        }
        return false;
    }

    private boolean applyTreeInsertNode(@NotNull String aKey, @Nullable Object aValue) {
        CEventInsertTreeNode event = CEventInsertTreeNode.create((Object)aValue);
        if (event != null) {
            CEventTreeNode eventNode = event.getNode();
            ERelation relation = event.getRelation();
            String relationNodeId = event.getRelationNodeId();
            CTreeNode node = CUtilConvertTreeNodes.convert(eventNode);
            this.mNodes.insert(node, relation, relationNodeId);
            return true;
        }
        return false;
    }

    private boolean applyTreeSetNodes(@NotNull String aKey, @Nullable Object aValue) {
        CEventTreeNode event = CEventTreeNode.create((Object)aValue);
        if (event != null) {
            CTreeNode node = CUtilConvertTreeNodes.convert(event);
            this.mNodes.setNodes(node);
            DefaultTreeModel model = (DefaultTreeModel)this.getComponent().getModel();
            CTreeNode rootNode = this.mNodes.getRootNode();
            if (rootNode != null) {
                model.setRoot(rootNode.getSwingNode());
                model.reload();
                return true;
            }
        }
        return false;
    }

    @NotNull
    public JTree getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Tree.name();
    }

    @Override
    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        super.fileArrived(aRelativePath, aToken, aImage);
        this.mIconHandler.fileArrived(aToken, aImage);
    }

    private CNodeRenderer getCellRenderer() {
        return (CNodeRenderer)this.mComponent.getCellRenderer();
    }

    boolean isUseSingleNodeRenderer() {
        return this.mUseSingleNodeRenderer;
    }

    @Nullable
    private TreePath getTreePath(@NotNull String aNodeId) {
        CTreeNode node = this.mNodes.get(aNodeId);
        if (node != null) {
            return new TreePath(node.getSwingNode().getPath());
        }
        return null;
    }
}

