/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.command;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonCompactWriter;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.command.CAttributeEntry;
import de.sillysky.nyssr.remoteskin.model.command.CListOfAttributes;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandSender;
import de.sillysky.nyssr.remoteskin.model.keys.ENotificationJsonKeys;
import de.sillysky.nyssr.remoteskin.model.records.CRecordRemoteSkinApplyAttributes;
import de.sillysky.nyssr.target.ITarget;
import org.jetbrains.annotations.NotNull;

public class CJsonCommandSender
implements IJsonCommandSender {
    private static final ILogger LOG = CLoggerFactory.getLogger(CJsonCommandSender.class);
    private final IJsonCompactWriter mWriter;
    private final CListOfAttributes mAttributes = new CListOfAttributes();

    public CJsonCommandSender(@NotNull IJsonCompactWriter aWriter) {
        this.mWriter = aWriter;
    }

    public void addAttribute(@NotNull String aWidgetSetName, @NotNull String aWidgetSetInstance, @NotNull String aWidgetName, @NotNull String aKey, @NotNull Object aValue) {
        CWidgetId widgetId = CWidgetId.create((String)aWidgetName, (String)aWidgetSetName, (String)aWidgetSetInstance);
        CAttributeEntry entry = new CAttributeEntry(widgetId, aKey, aValue);
        this.mAttributes.add(entry);
    }

    public void addAttribute(@NotNull CWidgetId aWidgetId, @NotNull String aKey, @NotNull Object aValue) {
        CAttributeEntry entry = new CAttributeEntry(aWidgetId, aKey, aValue);
        this.mAttributes.add(entry);
    }

    public void send(@NotNull CTargetAddress aReceiverAddress, @NotNull ITarget aSenderTarget) {
        if (!this.isEmpty()) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aReceiverAddress);
                String json = this.toJson();
                CRecord record = CRecordRemoteSkinApplyAttributes.create();
                CRecordRemoteSkinApplyAttributes.setJson((CRecord)record, (String)json);
                aSenderTarget.sendNotification(env, record);
            }
            catch (CException aE) {
                LOG.error((Throwable)aE, "Error sending json command");
            }
        }
    }

    public void send(@NotNull CTargetAddress aSenderAddress, @NotNull CTargetAddress aReceiverAddress, @NotNull IMessageSender aSenderService) {
        if (!this.isEmpty()) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aReceiverAddress);
                env.setSender(aSenderAddress);
                String json = this.toJson();
                CRecord record = CRecordRemoteSkinApplyAttributes.create();
                CRecordRemoteSkinApplyAttributes.setJson((CRecord)record, (String)json);
                aSenderService.sendNotification(env, record);
            }
            catch (CException aE) {
                LOG.error((Throwable)aE, "Error sending json command");
            }
        }
    }

    public boolean isEmpty() {
        return this.mAttributes.isEmpty();
    }

    public void deactivate() {
        this.mAttributes.deactivate();
    }

    @NotNull
    private String toJson() {
        CJsonObject root = new CJsonObject(true);
        CJsonArray attributes = new CJsonArray();
        for (CAttributeEntry a : this.mAttributes.getAll()) {
            CJsonArray arr = new CJsonArray();
            arr.add((Object)a.getWidgetId().valueToString());
            arr.add((Object)a.getKey());
            arr.add(a.getValue());
            attributes.add((Object)arr);
        }
        root.put(ENotificationJsonKeys.attributes.name(), (Object)attributes);
        StringBuilder sb = new StringBuilder(3000);
        this.mWriter.write(sb, (Object)root);
        return sb.toString();
    }
}

