/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.importfile;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.impl.file.store.importfile.CJobImportFile;
import de.sillysky.nyssr.impl.file.store.service.IDependencies;
import de.sillysky.nyssr.impl.file.store.service.IFileStore;
import de.sillysky.nyssr.job.IJob;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.jetbrains.annotations.NotNull;

public class CImportFileHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CImportFileHandler.class);
    private final IDependencies mDependencies;
    private final IFileStore mFileStore;

    public CImportFileHandler(@NotNull IDependencies aDependencies, @NotNull IFileStore aFileStore) {
        this.mDependencies = aDependencies;
        this.mFileStore = aFileStore;
    }

    public void importIncomingFiles() {
        final Path incomingPath = this.mFileStore.getDirectoryForIncomingFiles();
        final Path indexedPath = this.mFileStore.getDirectoryForIndexedFiles();
        if (incomingPath != null && indexedPath != null) {
            final CTargetAddress address = this.mFileStore.getAddress();
            try {
                Files.walkFileTree(incomingPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                    final /* synthetic */ CImportFileHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path aDir, BasicFileAttributes attrs) {
                        String relativePath = CUtilPath.getRelativePath((Path)incomingPath, (String)aDir.toString());
                        Path path = indexedPath.resolve(relativePath);
                        CUtilFile.createDirectories((Path)path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path aPath, BasicFileAttributes attrs) {
                        String relativePath = CUtilPath.getRelativePath((Path)incomingPath, (String)aPath.toString());
                        CJobImportFile job = new CJobImportFile(this.this$0.mDependencies, aPath, indexedPath, relativePath, address, true);
                        this.this$0.mFileStore.getJobEngine().appendJob((IJob)job);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException aE) {
                LOG.error((Throwable)aE);
            }
        }
    }
}

