/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.converter.impl.converter;

import de.sillysky.nyssr.converter.IConverter;
import de.sillysky.nyssr.converter.IConverterRegistry;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.swing.color.CNamedColor;
import de.sillysky.nyssr.util.swing.color.CNamedColors;
import java.awt.Color;
import java.util.Map;

public final class CColorToString
implements IConverter<Color, String> {
    @Override
    public String convertTo(Color aColor, Map<String, Object> aConstraints) {
        if (aColor == null) {
            return "null";
        }
        CUtilCheck.checkEqual(aColor.getClass(), Color.class, "No Color instance", new Object[0]);
        StringBuilder sb = new StringBuilder(50);
        CNamedColor namedColor = CNamedColors.get(aColor.getRed(), aColor.getGreen(), aColor.getBlue());
        if (namedColor != null) {
            sb.append(namedColor.getName());
            sb.append(",");
            sb.append(aColor.getAlpha());
        } else {
            sb.append(aColor.getRed());
            sb.append(",");
            sb.append(aColor.getGreen());
            sb.append(",");
            sb.append(aColor.getBlue());
            sb.append(",");
            sb.append(aColor.getAlpha());
        }
        return sb.toString();
    }

    @Override
    public Class<?> getDestinationClass() {
        return String.class;
    }

    @Override
    public String getDestinationType() {
        return "";
    }

    @Override
    public Class<?> getSourceClass() {
        return Color.class;
    }

    @Override
    public String getSourceType() {
        return "";
    }

    @Override
    public void setRegistry(IConverterRegistry aRegistry) {
    }
}

