/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.util;

import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.util.CJsonEnvelopeUtil;
import de.sillysky.nyssr.impl.util.CJsonRecordUtil;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CJsonMessageUtil {
    private static final String KEY_ENVELOPE = "env";
    private static final String KEY_RECORD = "rec";

    private CJsonMessageUtil() {
    }

    @NotNull
    public static Object toJson(@NotNull CMessage aMessage, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CJsonObject jo = new CJsonObject(true);
        CJsonObject jo1 = new CJsonObject(true);
        CEnvelope env = aMessage.getEnvelope();
        CJsonEnvelopeUtil.addressesToJson(env, jo1);
        CJsonEnvelopeUtil.otherToJson(env, jo1);
        CJsonEnvelopeUtil.debugToJson(env, jo1);
        jo.put(KEY_ENVELOPE, jo1);
        CJsonObject jo2 = CJsonRecordUtil.toJson(aMessage.getRecord(), aByteArrayStore);
        jo.put(KEY_RECORD, jo2);
        return jo;
    }

    @Nullable
    public static CMessage fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        CJsonObject jo;
        Object o;
        ISlotFactory slotFactory;
        if (aValue instanceof CJsonObject && (slotFactory = CServiceRegistry.getInstance().getService(ISlotFactory.class)) != null && (o = (jo = (CJsonObject)aValue).getValue(KEY_ENVELOPE)) instanceof CJsonObject) {
            CJsonObject jo1 = (CJsonObject)o;
            CEnvelope env = new CEnvelope();
            CJsonEnvelopeUtil.fromJsonAddresses(jo1, env);
            CJsonEnvelopeUtil.fromJsonOther(jo1, env);
            CJsonEnvelopeUtil.fromJsonDebug(jo1, env);
            o = jo.getValue(KEY_RECORD);
            if (o instanceof CJsonObject) {
                CRecord record = CJsonRecordUtil.fromJson(o, aByteArrayStore, slotFactory);
                return new CMessage(env, record);
            }
        }
        return null;
    }
}

