/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.result;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.ILogger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CResult {
    private final StringBuilder mStringBuilder = new StringBuilder(100);
    private int mCode;

    public CResult() {
        this(0, "");
    }

    public CResult(@NotNull CException aEx) {
        this(aEx.getCode(), aEx.getMessage());
    }

    public CResult(@NotNull CResult aResult) {
        this.mCode = aResult.mCode;
        this.mStringBuilder.append(aResult.getText());
    }

    public CResult(int aCode) {
        this(aCode, "");
    }

    public CResult(int aCode, String aText) {
        this.mCode = aCode;
        this.mStringBuilder.append(aText);
    }

    public CResult(@NotNull Throwable aT) {
        this(2, aT.getMessage());
    }

    public static boolean hasSuccess(CResult aResult) {
        return aResult == null || aResult.mCode == 0;
    }

    public CResult append(boolean aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(byte aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(char aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(double aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(float aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(int aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(long aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(Object aObj) {
        this.mStringBuilder.append(aObj);
        return this;
    }

    public CResult append(short aValue) {
        this.mStringBuilder.append(aValue);
        return this;
    }

    public CResult append(String aText) {
        this.mStringBuilder.append(aText);
        return this;
    }

    public int getCode() {
        return this.mCode;
    }

    public CResult setCode(int aCode) {
        this.mCode = aCode;
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public String getCombinedText() {
        return this.mCode + " (" + String.valueOf(this.mStringBuilder) + ")";
    }

    public boolean isSuccess() {
        return this.mCode == 0;
    }

    @Contract(pure=true)
    @NotNull
    public String getText() {
        return this.mStringBuilder.toString();
    }

    public boolean hasSuccess() {
        return this.mCode == 0;
    }

    public CResult log(@NotNull ILogger aLogger) {
        if (this.mCode != 0) {
            aLogger.error("Error {}: {}", this.mCode, this.mStringBuilder.toString());
        }
        return this;
    }

    public CResult set(int aCode, String aText) {
        this.mCode = aCode;
        this.mStringBuilder.setLength(0);
        this.mStringBuilder.append(aText);
        return this;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return this.mCode + " - " + this.getText();
    }
}

