/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.slot;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotFactoryHelper {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSlotFactoryHelper.class);

    private CSlotFactoryHelper() {
    }

    @Nullable
    public static ISlot create(@NotNull CSlotType aType) throws CException {
        return CSlotFactoryHelper.fromObject(aType, null);
    }

    public static ISlot fromObject(CSlotType aType, Object aValue) throws CException {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            return sf.fromObject(aType, aValue);
        }
        throw new CException(2007).append("The slot type ").append(aType).append(" is unknown.");
    }

    @Nullable
    public static ISlot fromObject(@Nullable Object aValue) {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            return sf.fromObject(aValue);
        }
        return null;
    }

    @Nullable
    public static ISlot fromStream(@NotNull DataInput aStream) throws IOException {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            return sf.fromStream(aStream);
        }
        return null;
    }

    @Nullable
    private static ISlotFactory getFactory() {
        ISlotFactory slotFactory = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (slotFactory == null) {
            Thread.dumpStack();
            LOG.error("Factory is null.");
        }
        return slotFactory;
    }

    @Nullable
    public static CSlotType getSlotTypeByName(@NotNull String aName) {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            return sf.getSlotTypeByName(aName);
        }
        return null;
    }

    @Nullable
    public static CSlotType getSlotTypeByOrdinal(int aOrdinal) {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            return sf.getSlotTypeByOrdinal(aOrdinal);
        }
        return null;
    }

    public static void registerFactory(@NotNull CSlotType aType, @NotNull ISingleSlotTypeFactory aFactory) {
        ISlotFactory sf = CServiceRegistry.getInstance().getService(ISlotFactory.class);
        if (sf != null) {
            sf.registerFactory(aType, aFactory);
        }
    }

    public static void toStream(@NotNull ISlot aSlot, @NotNull DataOutput aStream) throws IOException {
        ISlotFactory sf = CSlotFactoryHelper.getFactory();
        if (sf != null) {
            sf.toStream(aStream, aSlot);
        }
    }
}

