/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.kernel.records.CRecordDismiss;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.message.handler.registry.IMessageHandler;
import de.sillysky.nyssr.message.handler.registry.IMessageHandlerRegistry;
import de.sillysky.nyssr.message.handler.registry.IMessageHandlerRegistryFactory;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.records.CRecordPing;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.timer.ITimerManager;
import de.sillysky.nyssr.util.dismiss.CDismissListenerSupport;
import de.sillysky.nyssr.util.timer.CTimerThreshold;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTarget
implements ITarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTarget.class);
    private static final IId TIMER_MAINTENANCE = CIdFactory.fromObject("TimerMaintenance");
    private static final long TIMEOUT_MAINTENANCE = 60000L;
    private final IMessageHandlerRegistry mMessageHandlerRegistry;
    private final Map<CTargetAddress, CTimerThreshold> mAddressesToTrack = new HashMap<CTargetAddress, CTimerThreshold>();
    private CTargetAddress mAddress = CTargetAddress.getInvalidAddress();
    private IMessageSender mMessageSender;
    private ITargetRegistry mTargetRegistry;
    private IId mQueueId = IId.INVALID;
    private CTimer mMaintenanceTimer;
    private CTimerThreshold mSelfDestruction = null;
    private int mPingCounter = 0;
    private final CDismissListenerSupport mDismissListenerSupport = new CDismissListenerSupport();

    public CTarget() {
        CServiceRegistry sr = CServiceRegistry.getInstance();
        IMessageHandlerRegistryFactory factory = sr.getService(IMessageHandlerRegistryFactory.class);
        assert (factory != null);
        this.mMessageHandlerRegistry = factory.createMessageHandlerRegistry(this);
        this.addMessageHandler(CRecordPing.ID, this::asyncTargetPing);
        this.addMessageHandler(TIMER_MAINTENANCE, this::asyncTimerTargetMaintenance);
        this.addMessageHandler(CRecordDismiss.ID, this::asyncDismiss);
    }

    private boolean asyncTimerTargetMaintenance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mMaintenanceTimer.notifyTriggerOccurred();
        aEnvelope.setResultSuccess();
        if (this.mSelfDestruction != null && this.mSelfDestruction.hasExpired()) {
            LOG.warn("Self Destruction timeout reached after {} seconds.", this.mSelfDestruction.getThreshold() / 1000L);
            this.deregisterTarget();
            return true;
        }
        if (!this.mAddressesToTrack.isEmpty()) {
            for (Map.Entry<CTargetAddress, CTimerThreshold> e : this.mAddressesToTrack.entrySet()) {
                CTargetAddress address = e.getKey();
                CTimerThreshold threshold = e.getValue();
                if (threshold.hasExpired()) {
                    LOG.warn("Ping value for Target {} has reached timeout after {} seconds.", address, threshold.getThreshold() / 1000L);
                    this.deregisterTarget();
                    return true;
                }
                try {
                    this.ping(address);
                }
                catch (CException cException) {}
            }
        }
        if (!this.mAddressesToTrack.isEmpty() || this.mSelfDestruction != null) {
            this.mMaintenanceTimer.startIf();
        }
        return true;
    }

    protected boolean asyncTargetPing(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        long counter = CRecordPing.getLoop(aRecord, 0L);
        if (aEnvelope.isAnswer()) {
            CTargetAddress sender;
            CTimerThreshold threshold;
            long copy;
            if (aEnvelope.getResult().isSuccess() && (copy = CRecordPing.getLoopMirror(aRecord, 0L)) == counter && (threshold = this.mAddressesToTrack.get(sender = aEnvelope.getSender())) != null) {
                threshold.signalActivity();
                if (this.mSelfDestruction != null) {
                    this.mSelfDestruction.signalActivity();
                }
            }
        } else {
            CRecordPing.setLoopMirror(aRecord, counter);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    protected boolean asyncDismiss(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.deregisterTarget();
        aEnvelope.setResultSuccess();
        return true;
    }

    @Override
    public void addMessageHandler(@Nullable IId aMID, @NotNull IMessageHandler aHandler) {
        this.mMessageHandlerRegistry.addMessageHandler(aMID, aHandler);
    }

    private void checkRegistered() throws CException {
        if (this.mMessageSender == null) {
            throw new CException(2508).append("Target not registered.");
        }
    }

    private void completeReceiver(@NotNull CEnvelope aEnvelope) {
        CTargetAddress oldReceiver = aEnvelope.getReceiver();
        IId nid = oldReceiver.getNID();
        if (CIdFactory.isEmpty(nid)) {
            CTargetAddress newReceiver = new CTargetAddress(oldReceiver.getTID(), this.mAddress.getNID(), oldReceiver.getNodeAddress());
            aEnvelope.setReceiver(newReceiver);
        }
    }

    @Override
    public final void deregisterTarget() {
        if (this.mTargetRegistry != null) {
            this.mTargetRegistry.deregisterTarget(this.mAddress);
        }
    }

    @Override
    public final CTargetAddress getAddress() {
        return this.mAddress;
    }

    @Override
    public String getCurrentName() {
        return this.getClass().getSimpleName();
    }

    protected IMessageHandlerRegistry getMessageHandlerRegistry() {
        return this.mMessageHandlerRegistry;
    }

    @Override
    public IMessageSender getMessageSender() {
        return this.mMessageSender;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final IId getQueueId() {
        return this.mQueueId;
    }

    @Override
    public ITargetRegistry getTargetRegistry() {
        return this.mTargetRegistry;
    }

    @Override
    public void handleMessage(@NotNull CMessage aMsg) throws Exception {
        this.mMessageHandlerRegistry.handleMessage(aMsg);
    }

    @Override
    public final boolean isTargetRegistered() {
        return this.mMessageSender != null;
    }

    @Override
    public final boolean isVerbose() {
        return this.mMessageHandlerRegistry.isVerbose();
    }

    @Override
    public void setVerbose(boolean aVerbose) {
        this.mMessageHandlerRegistry.setVerbose(aVerbose);
    }

    @Override
    public void notifyTargetDeRegistered() {
        this.mAddress = CTargetAddress.getInvalidAddress();
    }

    @Override
    public void notifyTargetRegistered(@NotNull CTargetAddress aAddress, @NotNull IId aQID, @NotNull ITargetRegistry aTargetRegistry, @NotNull IMessageSender aMessageSender, @NotNull IMessageLogger aMessageLogger) {
        this.mAddress = aAddress;
        this.mQueueId = aQID;
        this.mTargetRegistry = aTargetRegistry;
        this.mMessageSender = aMessageSender;
        this.mMessageHandlerRegistry.setMessageLogger(aMessageLogger);
    }

    @Override
    public void notifyTargetWillBeRemoved() throws Exception {
        this.mDismissListenerSupport.notifyListener(this);
    }

    public final void ping(@NotNull CTargetAddress aReceiver) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget(aReceiver);
        env.setLogEnabled(false);
        CRecord rec = new CRecord(CRecordPing.ID);
        CRecordPing.setLoop(rec, this.mPingCounter++);
        this.sendRequest(env, rec);
    }

    @Override
    public void removeMessageHandler(@NotNull IId aMID) {
        this.mMessageHandlerRegistry.removeMessageHandler(aMID);
    }

    @Override
    public void removeMessageHandler(@NotNull IId aMID, @NotNull IMessageHandler aHandler) {
        this.mMessageHandlerRegistry.removeMessageHandler(aMID, aHandler);
    }

    @Override
    public void send(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.checkRegistered();
        aEnvelope.setSender(this.mAddress);
        this.getMessageSender().send(aEnvelope, aRecord);
    }

    @Override
    public void send(@NotNull CMessage aMsg) throws CException {
        this.checkRegistered();
        CEnvelope env = aMsg.getEnvelope();
        env.setSender(this.mAddress);
        this.getMessageSender().send(aMsg);
    }

    @Override
    public void sendNotification(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        aEnvelope.setWantAnswer(false);
        this.send(aEnvelope, aRecord);
    }

    @Override
    public void sendNotification(@NotNull CMessage aMsg) throws CException {
        aMsg.getEnvelope().setWantAnswer(false);
        this.send(aMsg);
    }

    @Override
    public void sendRequest(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        aEnvelope.setWantAnswer(true);
        this.send(aEnvelope, aRecord);
    }

    @Override
    public void sendRequest(@NotNull CMessage aMsg) throws CException {
        aMsg.getEnvelope().setWantAnswer(true);
        this.send(aMsg);
    }

    @Override
    @NotNull
    public INamespace getNamespace() {
        return this.mTargetRegistry.getNamespace();
    }

    @Override
    public void setMessageLogger(@NotNull IMessageLogger aMessageLogger) {
        this.mMessageHandlerRegistry.setMessageLogger(aMessageLogger);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        String name = super.getClass().getSimpleName();
        sb.append(name);
        if (this.mAddress == null) {
            sb.append(" is not registered");
        } else {
            sb.append(' ');
            sb.append(this.mAddress);
        }
        return sb.toString();
    }

    public final void triggerThisTarget(@NotNull IId aMID) throws CException {
        CEnvelope env = CEnvelope.forSingleTarget(this.mAddress);
        CRecord rec = new CRecord(aMID);
        this.send(env, rec);
    }

    public void stopPingingAddress(@NotNull CTargetAddress aAddressToTrack) {
        CTimerThreshold threshold = this.mAddressesToTrack.remove(aAddressToTrack);
        this.stopMaintenanceTimerIf();
    }

    public void startPingingAddress(@NotNull CTargetAddress aAddressToTrack, int aTimeoutInSeconds) throws CException {
        CTimerThreshold threshold = this.mAddressesToTrack.get(aAddressToTrack);
        if (threshold == null) {
            threshold = new CTimerThreshold((long)aTimeoutInSeconds * 1000L);
            this.mAddressesToTrack.put(aAddressToTrack, threshold);
            this.ping(aAddressToTrack);
        } else {
            threshold.setThreshold((long)aTimeoutInSeconds * 1000L);
        }
        this.startMaintenanceTimerIf();
    }

    public void startSelfDestruction(int aMaxSecondsWithoutActivity) throws CException {
        this.mSelfDestruction = new CTimerThreshold((long)aMaxSecondsWithoutActivity * 1000L);
        this.startMaintenanceTimerIf();
    }

    public void stopSelfDestruction() {
        this.mSelfDestruction = null;
        this.stopMaintenanceTimerIf();
    }

    public void triggerActivity() {
        this.mSelfDestruction.signalActivity();
    }

    private void stopMaintenanceTimerIf() {
        if (this.mMaintenanceTimer != null && this.mAddressesToTrack.isEmpty() && this.mSelfDestruction == null) {
            this.mMaintenanceTimer.dismiss();
            this.mMaintenanceTimer = null;
        }
    }

    private void startMaintenanceTimerIf() throws CException {
        if (this.mMaintenanceTimer == null) {
            ITimerManager timerManager = CServiceRegistry.getInstance().getServiceOrThrow(ITimerManager.class);
            this.mMaintenanceTimer = new CTimer(timerManager, TIMER_MAINTENANCE, this.getAddress(), 60000L, false, null);
            this.mMaintenanceTimer.startIf();
        }
    }

    public void signalActivity(@Nullable CTargetAddress aAddress) {
        CTimerThreshold threshold;
        if (this.mSelfDestruction != null) {
            this.mSelfDestruction.signalActivity();
        }
        if (aAddress != null && (threshold = this.mAddressesToTrack.get(aAddress)) != null) {
            threshold.signalActivity();
        }
    }

    public CDismissListenerSupport getDismissListenerSupport() {
        return this.mDismissListenerSupport;
    }
}

