/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.swing.CLowerStringMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CIntegerToStringMap {
    private static final ILogger LOG = CLoggerFactory.getLogger(CIntegerToStringMap.class);
    private final String mName;
    private final Map<String, Integer> mIntegerByString = new HashMap<String, Integer>();
    private final Map<Integer, String> mStringByInteger = new HashMap<Integer, String>();
    private final CLowerStringMap mKeyMap = new CLowerStringMap();

    public CIntegerToStringMap(String aName) {
        this.mName = aName;
    }

    public void add(@NotNull String aKey, int aValue) {
        String key = this.prepareKey(aKey);
        if (!key.isEmpty()) {
            this.mIntegerByString.put(key, aValue);
            this.mStringByInteger.put(aValue, aKey);
            this.mKeyMap.add(aKey);
        }
    }

    public void remove(@NotNull String aKey) {
        Integer removed;
        String key = this.prepareKey(aKey);
        if (!key.isEmpty() && (removed = this.mIntegerByString.remove(key)) != null) {
            this.mStringByInteger.remove(removed);
            this.mKeyMap.remove(aKey);
        }
    }

    @NotNull
    private String prepareKey(@Nullable String aKey) {
        if (aKey == null) {
            return "";
        }
        return CUtilNormalize.normalize(aKey);
    }

    @Nullable
    public Integer get(@NotNull String aKey) {
        String key = this.prepareKey(aKey);
        Integer result = this.mIntegerByString.get(key);
        if (result == null) {
            LOG.warn("{}: Key {} not supported", this.mName, aKey);
        }
        return result;
    }

    @Nullable
    public String get(int aKey) {
        String result = this.mStringByInteger.get(aKey);
        if (result == null) {
            LOG.warn("{}: Key {} not supported", this.mName, aKey);
        }
        return result;
    }

    public int get(@Nullable String aKey, int aDefault) {
        String key = this.prepareKey(aKey);
        if (CUtilString.isEmpty(key)) {
            return aDefault;
        }
        Integer result = this.mIntegerByString.get(key);
        if (result == null) {
            LOG.warn("{}: Key {} not supported, assume {}", this.mName, key, aDefault);
            result = aDefault;
        }
        return result;
    }

    @NotNull
    public String get(int aKey, @NotNull String aDefault) {
        String result = this.mStringByInteger.get(aKey);
        if (result == null) {
            LOG.warn("{}: Key {} not supported, assume {}", this.mName, aKey, aDefault);
            result = aDefault;
        }
        return result;
    }

    @Nullable
    public String getKeyName(@NotNull String aKey) {
        return this.mKeyMap.getOriginalOrUnknown(aKey);
    }

    public String getSupportedValues() {
        return this.mKeyMap.getSupportedValues();
    }
}

