/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.tcp;

import de.sillysky.nyssr.util.bytecarousel.CByteCarousel;
import de.sillysky.nyssr.util.tcp.IInputListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CStreamInput {
    private final CByteCarousel mByteCarousel;
    private final IInputListener mListener;
    private final byte[] mChunkHeader;
    private final byte[] mHeaderBuffer;
    private final int mMaxChunkLenLen;
    private final Object mOwner;

    public CStreamInput(Object aOwner, byte[] aChunkHeader, int aMaxChunkLenLen, @NotNull IInputListener aListener) {
        this.mOwner = aOwner;
        this.mByteCarousel = new CByteCarousel();
        this.mListener = aListener;
        this.mChunkHeader = aChunkHeader;
        this.mMaxChunkLenLen = aMaxChunkLenLen;
        this.mHeaderBuffer = new byte[this.mChunkHeader.length];
    }

    public void put(byte[] aBytes) throws IOException {
        this.put(aBytes, 0, aBytes.length);
    }

    public void put(byte[] aBytes, int aPosition, int aLength) throws IOException {
        this.mByteCarousel.getOutputStream().write(aBytes, aPosition, aLength);
        InputStream stream = this.mByteCarousel.getInputStream();
        DataInputStream dis = new DataInputStream(stream);
        int available;
        while ((available = stream.available()) > this.mChunkHeader.length + 4) {
            dis.mark(available);
            int read = dis.read(this.mHeaderBuffer);
            if (read != this.mChunkHeader.length) {
                dis.reset();
                return;
            }
            if (!Arrays.equals(this.mHeaderBuffer, this.mChunkHeader)) {
                dis.reset();
                dis.readByte();
                continue;
            }
            int len = dis.readInt();
            if (len > this.mMaxChunkLenLen) {
                dis.reset();
                dis.readByte();
                continue;
            }
            if (this.mByteCarousel.getAvailableRead() < len) {
                dis.reset();
                return;
            }
            byte[] bytes = new byte[len];
            dis.readFully(bytes);
            this.mListener.notifyInput(this.mOwner, bytes);
        }
        return;
    }
}

