/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.layout;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventFlowLayout
implements IRemoteSkinEvent {
    private static final String ALIGNMENT = "alignment";
    private static final String HORIZONTAL_GAP = "hgap";
    private static final String VERTICAL_GAP = "vgap";
    private static final EAlignment DEFAULT_ALIGNMENT = EAlignment.center;
    private static final int DEFAULT_GAP = 5;
    private final EAlignment mAlignment;
    private final int mHorizontalGap;
    private final int mVerticalGap;

    public CEventFlowLayout(@NotNull EAlignment aAlignment, int aHorizontalGap, int aVerticalGap) {
        this.mAlignment = aAlignment;
        this.mHorizontalGap = aHorizontalGap;
        this.mVerticalGap = aVerticalGap;
    }

    public CEventFlowLayout(EAlignment aAlignment) {
        this(aAlignment, 5, 5);
    }

    public CEventFlowLayout() {
        this(DEFAULT_ALIGNMENT, 5, 5);
    }

    @Nullable
    public static CEventFlowLayout create(@Nullable Object aValue) {
        boolean enabled;
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            EAlignment alignment = DEFAULT_ALIGNMENT;
            Object o = jo.getValue(ALIGNMENT);
            if (o instanceof String) {
                alignment = (EAlignment)((Object)CUtilEnum.fromString(EAlignment.class, (String)((String)o), (Object)((Object)DEFAULT_ALIGNMENT)));
            }
            int hGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)HORIZONTAL_GAP, (int)5);
            int vGap = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)VERTICAL_GAP, (int)5);
            return new CEventFlowLayout(alignment, hGap, vGap);
        }
        if (aValue instanceof String) {
            EAlignment alignment = (EAlignment)((Object)CUtilEnum.fromString(EAlignment.class, (String)((String)aValue), (Object)((Object)DEFAULT_ALIGNMENT)));
            return new CEventFlowLayout(alignment, 5, 5);
        }
        if (aValue instanceof Boolean && (enabled = ((Boolean)aValue).booleanValue())) {
            return new CEventFlowLayout(DEFAULT_ALIGNMENT, 5, 5);
        }
        return null;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mAlignment != null && this.mAlignment != EAlignment.center) {
            jo.put(ALIGNMENT, (Object)this.mAlignment.name());
        }
        if (this.mHorizontalGap != 5) {
            jo.put(HORIZONTAL_GAP, (Object)this.mHorizontalGap);
        }
        if (this.mVerticalGap != 5) {
            jo.put(VERTICAL_GAP, (Object)this.mVerticalGap);
        }
        return jo;
    }

    @NotNull
    public EAlignment getAlignment() {
        return this.mAlignment;
    }

    public int getHorizontalGap() {
        return this.mHorizontalGap;
    }

    public int getVerticalGap() {
        return this.mVerticalGap;
    }

    public int getSwingAlignment() {
        switch (this.mAlignment.ordinal()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 1;
    }

    public static enum EAlignment {
        center,
        left,
        right,
        leading,
        trailing;

    }
}

