/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.collector;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CMicroServiceInstance {
    private final IId mInstanceId;
    private final CMicroServiceDescription mDescription;
    private final CTargetAddress mTargetAddress;

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CMicroServiceInstance that = (CMicroServiceInstance)aO;
        return this.mInstanceId.equals((Object)that.mInstanceId) && this.mDescription.equals(that.mDescription);
    }

    public int hashCode() {
        return Objects.hash(this.mInstanceId, this.mDescription);
    }

    public CMicroServiceInstance(@NotNull CMicroServiceDescription aDescription, @NotNull IId aInstanceId, @NotNull CTargetAddress aTargetAddress) {
        this.mInstanceId = aInstanceId;
        this.mDescription = aDescription;
        this.mTargetAddress = aTargetAddress;
    }

    @NotNull
    public CMicroServiceDescription getDescription() {
        return this.mDescription;
    }

    @NotNull
    public CTargetAddress getTargetAddress() {
        return this.mTargetAddress;
    }

    @NotNull
    public IId getInstanceId() {
        return this.mInstanceId;
    }

    public String toString() {
        return "[MicroServiceInstance: MSId=" + String.valueOf(this.mDescription.getId()) + ", desc=" + this.mDescription.getDescription() + ", InstanceId=" + String.valueOf(this.mInstanceId) + "]";
    }
}

